// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Request body to create a composed document model from component document models.
 */
@Fluent
public final class ComposeDocumentModelOptions implements JsonSerializable<ComposeDocumentModelOptions> {

    /*
     * Unique document model name.
     */
    @Generated
    private final String modelId;

    /*
     * Document model description.
     */
    @Generated
    private String description;

    /*
     * Custom classifier to split and classify the input file.
     */
    @Generated
    private final String classifierId;

    /*
     * File splitting behavior.
     */
    @Generated
    private SplitMode split;

    /*
     * Dictionary mapping supported docTypes to the corresponding document models.
     */
    @Generated
    private final Map<String, DocumentTypeDetails> documentTypes;

    /*
     * List of key-value tag attributes associated with the document model.
     */
    @Generated
    private Map<String, String> tags;

    /**
     * Creates an instance of ComposeDocumentModelOptions class.
     *
     * @param modelId the modelId value to set.
     * @param classifierId the classifierId value to set.
     * @param documentTypes the documentTypes value to set.
     */
    @Generated
    public ComposeDocumentModelOptions(String modelId, String classifierId,
        Map<String, DocumentTypeDetails> documentTypes) {
        this.modelId = modelId;
        this.classifierId = classifierId;
        this.documentTypes = documentTypes;
    }

    /**
     * Get the modelId property: Unique document model name.
     *
     * @return the modelId value.
     */
    @Generated
    public String getModelId() {
        return this.modelId;
    }

    /**
     * Get the description property: Document model description.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: Document model description.
     *
     * @param description the description value to set.
     * @return the ComposeDocumentModelOptions object itself.
     */
    @Generated
    public ComposeDocumentModelOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the classifierId property: Custom classifier to split and classify the input file.
     *
     * @return the classifierId value.
     */
    @Generated
    public String getClassifierId() {
        return this.classifierId;
    }

    /**
     * Get the split property: File splitting behavior.
     *
     * @return the split value.
     */
    @Generated
    public SplitMode getSplit() {
        return this.split;
    }

    /**
     * Set the split property: File splitting behavior.
     *
     * @param split the split value to set.
     * @return the ComposeDocumentModelOptions object itself.
     */
    @Generated
    public ComposeDocumentModelOptions setSplit(SplitMode split) {
        this.split = split;
        return this;
    }

    /**
     * Get the documentTypes property: Dictionary mapping supported docTypes to the corresponding document models.
     *
     * @return the documentTypes value.
     */
    @Generated
    public Map<String, DocumentTypeDetails> getDocumentTypes() {
        return this.documentTypes;
    }

    /**
     * Get the tags property: List of key-value tag attributes associated with the document model.
     *
     * @return the tags value.
     */
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: List of key-value tag attributes associated with the document model.
     *
     * @param tags the tags value to set.
     * @return the ComposeDocumentModelOptions object itself.
     */
    @Generated
    public ComposeDocumentModelOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeMapField("docTypes", this.documentTypes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("split", this.split == null ? null : this.split.toString());
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ComposeDocumentModelOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ComposeDocumentModelOptions if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ComposeDocumentModelOptions.
     */
    @Generated
    public static ComposeDocumentModelOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String modelId = null;
            String classifierId = null;
            Map<String, DocumentTypeDetails> documentTypes = null;
            String description = null;
            SplitMode split = null;
            Map<String, String> tags = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                } else if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                } else if ("docTypes".equals(fieldName)) {
                    documentTypes = reader.readMap(reader1 -> DocumentTypeDetails.fromJson(reader1));
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("split".equals(fieldName)) {
                    split = SplitMode.fromString(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            ComposeDocumentModelOptions deserializedComposeDocumentModelOptions
                = new ComposeDocumentModelOptions(modelId, classifierId, documentTypes);
            deserializedComposeDocumentModelOptions.description = description;
            deserializedComposeDocumentModelOptions.split = split;
            deserializedComposeDocumentModelOptions.tags = tags;
            return deserializedComposeDocumentModelOptions;
        });
    }
}
