// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Document classification parameters.
 */
@Fluent
public final class ClassifyDocumentOptions implements JsonSerializable<ClassifyDocumentOptions> {

    private StringIndexType stringIndexType;

    private SplitMode split;

    private List<String> pages;

    /*
     * Document URL to classify. Either urlSource or base64Source must be specified.
     */
    @Generated
    private String urlSource;

    /*
     * Base64 encoding of the document to classify. Either urlSource or base64Source
     * must be specified.
     */
    @Generated
    private byte[] bytesSource;

    /**
     * Creates an instance of ClassifyDocumentOptions class.
     */
    @Generated
    ClassifyDocumentOptions() {
    }

    /**
     * Creates an instance of ClassifyDocumentOptions with the specified URL source.
     *
     * @param urlSource the URL of the document to classify.
     */
    public ClassifyDocumentOptions(String urlSource) {
        this.urlSource = urlSource;
    }

    /**
     * Creates an instance of ClassifyDocumentOptions with the specified bytes of the document.
     *
     * @param bytesSource the encoded bytes of the document to classify.
     */
    public ClassifyDocumentOptions(byte[] bytesSource) {
        this.bytesSource = bytesSource;
    }

    /**
     * Creates an instance of ClassifyDocumentOptions with the specified BinaryData source.
     *
     * @param binaryData the document to analyze.
     */
    public ClassifyDocumentOptions(BinaryData binaryData) {
        if (binaryData != null) {
            this.bytesSource = binaryData.toBytes();
        }
    }

    /**
     * Get the urlSource property: Document URL to classify. Either urlSource or base64Source must be specified.
     *
     * @return the urlSource value.
     */
    @Generated
    public String getUrlSource() {
        return this.urlSource;
    }

    /**
     * Get the bytesSource property: Base64 encoding of the document to classify. Either urlSource or base64Source
     * must be specified.
     *
     * @return the bytesSource value.
     */
    @Generated
    public byte[] getBytesSource() {
        return CoreUtils.clone(this.bytesSource);
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("urlSource", this.urlSource);
        jsonWriter.writeBinaryField("base64Source", this.bytesSource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClassifyDocumentOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClassifyDocumentOptions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClassifyDocumentOptions.
     */
    @Generated
    public static ClassifyDocumentOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClassifyDocumentOptions deserializedClassifyDocumentOptions = new ClassifyDocumentOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("urlSource".equals(fieldName)) {
                    deserializedClassifyDocumentOptions.urlSource = reader.getString();
                } else if ("base64Source".equals(fieldName)) {
                    deserializedClassifyDocumentOptions.bytesSource = reader.getBinary();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedClassifyDocumentOptions;
        });
    }

    /**
     * Gets the string index type.
     *
     * @return the string index type.
     */
    public StringIndexType getStringIndexType() {
        return stringIndexType;
    }

    /**
     * Sets the string index type.
     *
     * @param stringIndexType the string index type to set.
     * @return the updated {@code ClassifyDocumentOptions} value.
     */
    public ClassifyDocumentOptions setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    /**
     * Gets the split mode.
     *
     * @return the split mode.
     */
    public SplitMode getSplit() {
        return split;
    }

    /**
     * Sets the split mode.
     *
     * @param split the split mode to set.
     * @return the updated {@code ClassifyDocumentOptions} value.
     */
    public ClassifyDocumentOptions setSplit(SplitMode split) {
        this.split = split;
        return this;
    }

    /**
     * Gets the pages.
     *
     * @return the pages.
     */
    public List<String> getPages() {
        return pages;
    }

    /**
     * Sets the pages.
     *
     * @param pages the pages to set.
     * @return the updated {@code ClassifyDocumentOptions} value.
     */
    public ClassifyDocumentOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }

    /**
     * Set the urlSource property: Document URL to classify. Either urlSource or base64Source must be specified.
     *
     * @param urlSource the urlSource value to set.
     * @return the ClassifyDocumentOptions object itself.
     */
    @Generated
    ClassifyDocumentOptions setUrlSource(String urlSource) {
        this.urlSource = urlSource;
        return this;
    }

    /**
     * Set the bytesSource property: Base64 encoding of the document to classify. Either urlSource or base64Source
     * must be specified.
     *
     * @param bytesSource the bytesSource value to set.
     * @return the ClassifyDocumentOptions object itself.
     */
    @Generated
    ClassifyDocumentOptions setBytesSource(byte[] bytesSource) {
        this.bytesSource = CoreUtils.clone(bytesSource);
        return this;
    }
}
