// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Classifier document type info.
 */
@Fluent
public final class ClassifierDocumentTypeDetails implements JsonSerializable<ClassifierDocumentTypeDetails> {

    /*
     * Type of training data source.
     */
    @Generated
    private ContentSourceKind sourceKind;

    /*
     * Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     */
    @Generated
    private AzureBlobContentSource azureBlobSource;

    /*
     * Azure Blob Storage file list specifying the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     */
    @Generated
    private AzureBlobFileListContentSource azureBlobFileListSource;

    /**
     * Creates an instance of ClassifierDocumentTypeDetails class.
     */
    @Generated
    public ClassifierDocumentTypeDetails() {
    }

    /**
     * Get the sourceKind property: Type of training data source.
     *
     * @return the sourceKind value.
     */
    @Generated
    public ContentSourceKind getSourceKind() {
        return this.sourceKind;
    }

    /**
     * Set the sourceKind property: Type of training data source.
     *
     * @param sourceKind the sourceKind value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    @Generated
    public ClassifierDocumentTypeDetails setSourceKind(ContentSourceKind sourceKind) {
        this.sourceKind = sourceKind;
        return this;
    }

    /**
     * Get the azureBlobSource property: Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     *
     * @return the azureBlobSource value.
     */
    @Generated
    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    /**
     * Set the azureBlobSource property: Azure Blob Storage location containing the training data for a classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     *
     * @param azureBlobSource the azureBlobSource value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    @Generated
    public ClassifierDocumentTypeDetails setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    /**
     * Get the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data for a
     * classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     *
     * @return the azureBlobFileListSource value.
     */
    @Generated
    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    /**
     * Set the azureBlobFileListSource property: Azure Blob Storage file list specifying the training data for a
     * classifier
     * document type. Either azureBlobSource or azureBlobFileListSource must be
     * specified.
     *
     * @param azureBlobFileListSource the azureBlobFileListSource value to set.
     * @return the ClassifierDocumentTypeDetails object itself.
     */
    @Generated
    public ClassifierDocumentTypeDetails
        setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceKind", this.sourceKind == null ? null : this.sourceKind.toString());
        jsonWriter.writeJsonField("azureBlobSource", this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", this.azureBlobFileListSource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ClassifierDocumentTypeDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ClassifierDocumentTypeDetails if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ClassifierDocumentTypeDetails.
     */
    @Generated
    public static ClassifierDocumentTypeDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ClassifierDocumentTypeDetails deserializedClassifierDocumentTypeDetails
                = new ClassifierDocumentTypeDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceKind".equals(fieldName)) {
                    deserializedClassifierDocumentTypeDetails.sourceKind
                        = ContentSourceKind.fromString(reader.getString());
                } else if ("azureBlobSource".equals(fieldName)) {
                    deserializedClassifierDocumentTypeDetails.azureBlobSource = AzureBlobContentSource.fromJson(reader);
                } else if ("azureBlobFileListSource".equals(fieldName)) {
                    deserializedClassifierDocumentTypeDetails.azureBlobFileListSource
                        = AzureBlobFileListContentSource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedClassifierDocumentTypeDetails;
        });
    }
}
