// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Additional output to generate during analysis.
 */
public final class AnalyzeOutputFormat extends ExpandableStringEnum<AnalyzeOutputFormat> {

    /**
     * Generate searchable PDF output.
     */
    @Generated
    public static final AnalyzeOutputFormat PDF = fromString("pdf");

    /**
     * Generate cropped images of detected figures.
     */
    @Generated
    public static final AnalyzeOutputFormat FIGURES = fromString("figures");

    /**
     * Creates a new instance of AnalyzeOutputFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public AnalyzeOutputFormat() {
    }

    /**
     * Creates or finds a AnalyzeOutputFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AnalyzeOutputFormat.
     */
    @Generated
    public static AnalyzeOutputFormat fromString(String name) {
        return fromString(name, AnalyzeOutputFormat.class);
    }

    /**
     * Gets known AnalyzeOutputFormat values.
     *
     * @return known AnalyzeOutputFormat values.
     */
    @Generated
    public static Collection<AnalyzeOutputFormat> values() {
        return values(AnalyzeOutputFormat.class);
    }
}
