// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/**
 * Document analysis parameters.
 */
@Fluent
public final class AnalyzeDocumentOptions implements JsonSerializable<AnalyzeDocumentOptions> {

    private List<String> pages;

    private String locale;

    private List<DocumentAnalysisFeature> documentAnalysisFeatures;

    private StringIndexType stringIndexType;

    private List<String> queryFields;

    private DocumentContentFormat outputContentFormat;

    private List<AnalyzeOutputFormat> output;

    /*
     * Document URL to analyze. Either urlSource or base64Source must be specified.
     */
    @Generated
    private String urlSource;

    /*
     * Base64 encoding of the document to analyze. Either urlSource or base64Source
     * must be specified.
     */
    @Generated
    private byte[] bytesSource;

    /**
     * Creates an instance of AnalyzeDocumentOptions class.
     */
    @Generated
    AnalyzeDocumentOptions() {
    }

    /**
     * Creates an instance of AnalyzeDocumentOptions with the specified URL source.
     *
     * @param urlSource the URL of the document to analyze.
     */
    public AnalyzeDocumentOptions(String urlSource) {
        this.urlSource = urlSource;
    }

    /**
     * Creates an instance of AnalyzeDocumentOptions with the specified bytes of the document.
     *
     * @param bytesSource the bytes of the document to analyze.
     */
    public AnalyzeDocumentOptions(byte[] bytesSource) {
        this.bytesSource = bytesSource;
    }

    /**
     * Creates an instance of AnalyzeDocumentOptions with the specified BinaryData source.
     *
     * @param binaryData the document to analyze.
     */
    public AnalyzeDocumentOptions(BinaryData binaryData) {
        if (binaryData != null) {
            this.bytesSource = binaryData.toBytes();
        }
    }

    /**
     * Get the urlSource property: Document URL to analyze. Either urlSource or base64Source must be specified.
     *
     * @return the urlSource value.
     */
    @Generated
    public String getUrlSource() {
        return this.urlSource;
    }

    /**
     * Set the urlSource property: Document URL to analyze. Either urlSource or base64Source must be specified.
     *
     * @param urlSource the urlSource value to set.
     * @return the AnalyzeDocumentOptions object itself.
     */
    @Generated
    AnalyzeDocumentOptions setUrlSource(String urlSource) {
        this.urlSource = urlSource;
        return this;
    }

    /**
     * Get the bytesSource property: Base64 encoding of the document to analyze. Either urlSource or base64Source
     * must be specified.
     *
     * @return the bytesSource value.
     */
    @Generated
    public byte[] getBytesSource() {
        return CoreUtils.clone(this.bytesSource);
    }

    /**
     * Set the bytesSource property: Base64 encoding of the document to analyze. Either urlSource or base64Source
     * must be specified.
     *
     * @param bytesSource the bytesSource value to set.
     * @return the AnalyzeDocumentOptions object itself.
     */
    @Generated
    AnalyzeDocumentOptions setBytesSource(byte[] bytesSource) {
        this.bytesSource = CoreUtils.clone(bytesSource);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("urlSource", this.urlSource);
        jsonWriter.writeBinaryField("base64Source", this.bytesSource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeDocumentOptions from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeDocumentOptions if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AnalyzeDocumentOptions.
     */
    @Generated
    public static AnalyzeDocumentOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AnalyzeDocumentOptions deserializedAnalyzeDocumentOptions = new AnalyzeDocumentOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("urlSource".equals(fieldName)) {
                    deserializedAnalyzeDocumentOptions.urlSource = reader.getString();
                } else if ("base64Source".equals(fieldName)) {
                    deserializedAnalyzeDocumentOptions.bytesSource = reader.getBinary();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAnalyzeDocumentOptions;
        });
    }

    /**
     * Gets the list of additional fields to include in the result.
     *
     * @return the list of additional fields to include in the result.
     */
    public List<String> getQueryFields() {
        return queryFields;
    }

    /**
     * Sets the list of additional fields to include in the result.
     *
     * @param queryFields the list of additional fields to include in the result.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setQueryFields(List<String> queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    /**
     * Gets the output content format.
     *
     * @return the output content format.
     */
    public DocumentContentFormat getOutputContentFormat() {
        return outputContentFormat;
    }

    /**
     * Sets the output content format.
     *
     * @param outputContentFormat the output content format to set.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setOutputContentFormat(DocumentContentFormat outputContentFormat) {
        this.outputContentFormat = outputContentFormat;
        return this;
    }

    /**
     * Gets the list of output formats.
     *
     * @return the list of output formats.
     */
    public List<AnalyzeOutputFormat> getOutput() {
        return output;
    }

    /**
     * Sets the list of output formats.
     *
     * @param output the list of output formats to set.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setOutput(List<AnalyzeOutputFormat> output) {
        this.output = output;
        return this;
    }

    /**
     * Gets the string index type.
     *
     * @return the string index type.
     */
    public StringIndexType getStringIndexType() {
        return stringIndexType;
    }

    /**
     * Sets the string index type.
     *
     * @param stringIndexType the string index type to set.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    /**
     * Get the custom page numbers for multipage documents(PDF/TIFF). Input the number of the
     * pages you want to get the recognized result for.
     * <p>For a range of pages, use a hyphen, ex - ["1-3"]. Separate each page or a page
     * range with a comma, ex - ["1-3", 4].</p>
     *
     * @return the list of custom page numbers for a multipage document.
     */
    public List<String> getPages() {
        return pages;
    }

    /**
     * Set the custom page numbers for multipage documents(PDF/TIFF). Input the number of the
     * pages you want to get the recognized result for.
     * <p>For a range of pages, use a hyphen, ex - ["1-3"]. Separate each page or a page
     * range with a comma, ex - ["1-3", 4].</p>
     *
     * @param pages the custom page numbers value to set.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }

    /**
     * Get the locale hint for text recognition and document analysis.
     * Value may contain only the language code (ex. \"en\", \"fr\") or BCP 47 language tag (ex. \"en-US\").
     *
     * @return the locale value.
     */
    public String getLocale() {
        return locale;
    }

    /**
     * Set the locale value.
     * Supported locales include: en-AU, en-CA, en-GB, en-IN, en-US.
     *
     * @param locale the locale value to set.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    /**
     * Get the list of optional analysis features.
     *
     * @return List of optional analysis features.
     */
    public List<DocumentAnalysisFeature> getDocumentAnalysisFeatures() {
        return documentAnalysisFeatures;
    }

    /**
     * Set the list of optional analysis features.
     *
     * @param documentAnalysisFeatures List of optional analysis features.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setDocumentAnalysisFeatures(List<DocumentAnalysisFeature> documentAnalysisFeatures) {
        this.documentAnalysisFeatures = documentAnalysisFeatures;
        return this;
    }

    /**
     * Set optional analysis features.
     *
     * @param documentAnalysisFeatures List of optional analysis features.
     * @return the updated {@code AnalyzeDocumentOptions} value.
     */
    public AnalyzeDocumentOptions setDocumentAnalysisFeatures(DocumentAnalysisFeature... documentAnalysisFeatures) {
        if (documentAnalysisFeatures != null) {
            this.documentAnalysisFeatures = Arrays.asList(documentAnalysisFeatures);
        }
        return this;
    }
}
