// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Batch document analysis result.
 */
@Immutable
public final class AnalyzeBatchResult implements JsonSerializable<AnalyzeBatchResult> {

    /*
     * Number of documents that completed with status succeeded.
     */
    @Generated
    private final int succeededCount;

    /*
     * Number of documents that completed with status failed.
     */
    @Generated
    private final int failedCount;

    /*
     * Number of documents that completed with status skipped.
     */
    @Generated
    private final int skippedCount;

    /*
     * Operation detail for each document in the batch.
     */
    @Generated
    private List<AnalyzeBatchResultDetails> details;

    /**
     * Creates an instance of AnalyzeBatchResult class.
     *
     * @param succeededCount the succeededCount value to set.
     * @param failedCount the failedCount value to set.
     * @param skippedCount the skippedCount value to set.
     */
    @Generated
    private AnalyzeBatchResult(int succeededCount, int failedCount, int skippedCount) {
        this.succeededCount = succeededCount;
        this.failedCount = failedCount;
        this.skippedCount = skippedCount;
    }

    /**
     * Get the succeededCount property: Number of documents that completed with status succeeded.
     *
     * @return the succeededCount value.
     */
    @Generated
    public int getSucceededCount() {
        return this.succeededCount;
    }

    /**
     * Get the failedCount property: Number of documents that completed with status failed.
     *
     * @return the failedCount value.
     */
    @Generated
    public int getFailedCount() {
        return this.failedCount;
    }

    /**
     * Get the skippedCount property: Number of documents that completed with status skipped.
     *
     * @return the skippedCount value.
     */
    @Generated
    public int getSkippedCount() {
        return this.skippedCount;
    }

    /**
     * Get the details property: Operation detail for each document in the batch.
     *
     * @return the details value.
     */
    @Generated
    public List<AnalyzeBatchResultDetails> getDetails() {
        return this.details;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("succeededCount", this.succeededCount);
        jsonWriter.writeIntField("failedCount", this.failedCount);
        jsonWriter.writeIntField("skippedCount", this.skippedCount);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeBatchResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeBatchResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzeBatchResult.
     */
    @Generated
    public static AnalyzeBatchResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            int succeededCount = 0;
            int failedCount = 0;
            int skippedCount = 0;
            List<AnalyzeBatchResultDetails> details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("succeededCount".equals(fieldName)) {
                    succeededCount = reader.getInt();
                } else if ("failedCount".equals(fieldName)) {
                    failedCount = reader.getInt();
                } else if ("skippedCount".equals(fieldName)) {
                    skippedCount = reader.getInt();
                } else if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> AnalyzeBatchResultDetails.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            AnalyzeBatchResult deserializedAnalyzeBatchResult
                = new AnalyzeBatchResult(succeededCount, failedCount, skippedCount);
            deserializedAnalyzeBatchResult.details = details;
            return deserializedAnalyzeBatchResult;
        });
    }
}
