// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Status and result of the analyze batch operation.
 */
@Immutable
public final class AnalyzeBatchOperationDetails implements JsonSerializable<AnalyzeBatchOperationDetails> {

    /*
     * Analyze batch operation result ID.
     */
    @Generated
    private String resultId;

    /*
     * Operation status. notStarted, running, succeeded, or failed
     */
    @Generated
    private final DocumentIntelligenceOperationStatus status;

    /*
     * Date and time (UTC) when the operation was submitted.
     */
    @Generated
    private final OffsetDateTime createdOn;

    /*
     * Date and time (UTC) when the status was last updated.
     */
    @Generated
    private final OffsetDateTime lastUpdatedOn;

    /*
     * Operation progress (0-100).
     */
    @Generated
    private Integer percentCompleted;

    /*
     * Encountered error during batch document analysis.
     */
    @Generated
    private DocumentIntelligenceError error;

    /*
     * Batch document analysis result.
     */
    @Generated
    private AnalyzeBatchResult result;

    /**
     * Creates an instance of AnalyzeBatchOperationDetails class.
     *
     * @param status the status value to set.
     * @param createdOn the createdOn value to set.
     * @param lastUpdatedOn the lastUpdatedOn value to set.
     */
    @Generated
    private AnalyzeBatchOperationDetails(DocumentIntelligenceOperationStatus status, OffsetDateTime createdOn,
        OffsetDateTime lastUpdatedOn) {
        this.status = status;
        this.createdOn = createdOn;
        this.lastUpdatedOn = lastUpdatedOn;
    }

    /**
     * Get the resultId property: Analyze batch operation result ID.
     *
     * @return the resultId value.
     */
    @Generated
    public String getResultId() {
        return this.resultId;
    }

    /**
     * Get the status property: Operation status. notStarted, running, succeeded, or failed.
     *
     * @return the status value.
     */
    @Generated
    public DocumentIntelligenceOperationStatus getStatus() {
        return this.status;
    }

    /**
     * Get the createdOn property: Date and time (UTC) when the operation was submitted.
     *
     * @return the createdOn value.
     */
    @Generated
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    /**
     * Get the lastUpdatedOn property: Date and time (UTC) when the status was last updated.
     *
     * @return the lastUpdatedOn value.
     */
    @Generated
    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    /**
     * Get the percentCompleted property: Operation progress (0-100).
     *
     * @return the percentCompleted value.
     */
    @Generated
    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    /**
     * Get the error property: Encountered error during batch document analysis.
     *
     * @return the error value.
     */
    @Generated
    public DocumentIntelligenceError getError() {
        return this.error;
    }

    /**
     * Get the result property: Batch document analysis result.
     *
     * @return the result value.
     */
    @Generated
    public AnalyzeBatchResult getResult() {
        return this.result;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime",
            this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("lastUpdatedDateTime",
            this.lastUpdatedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedOn));
        jsonWriter.writeStringField("resultId", this.resultId);
        jsonWriter.writeNumberField("percentCompleted", this.percentCompleted);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeJsonField("result", this.result);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeBatchOperationDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeBatchOperationDetails if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnalyzeBatchOperationDetails.
     */
    @Generated
    public static AnalyzeBatchOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentIntelligenceOperationStatus status = null;
            OffsetDateTime createdOn = null;
            OffsetDateTime lastUpdatedOn = null;
            String resultId = null;
            Integer percentCompleted = null;
            DocumentIntelligenceError error = null;
            AnalyzeBatchResult result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("resultId".equals(fieldName)) {
                    resultId = reader.getString();
                } else if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = reader.getNullable(JsonReader::getInt);
                } else if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                } else if ("result".equals(fieldName)) {
                    result = AnalyzeBatchResult.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            AnalyzeBatchOperationDetails deserializedAnalyzeBatchOperationDetails
                = new AnalyzeBatchOperationDetails(status, createdOn, lastUpdatedOn);
            deserializedAnalyzeBatchOperationDetails.resultId = resultId;
            deserializedAnalyzeBatchOperationDetails.percentCompleted = percentCompleted;
            deserializedAnalyzeBatchOperationDetails.error = error;
            deserializedAnalyzeBatchOperationDetails.result = result;
            return deserializedAnalyzeBatchOperationDetails;
        });
    }
}
