// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.

package com.azure.ai.documentintelligence;

import com.azure.core.util.ServiceVersion;

/**
 * Service version of DocumentIntelligenceClient.
 */
public enum DocumentIntelligenceServiceVersion implements ServiceVersion {
    /**
     * Enum value 2024-11-30.
     */
    V2024_11_30("2024-11-30");

    private final String version;

    DocumentIntelligenceServiceVersion(String version) {
        this.version = version;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getVersion() {
        return this.version;
    }

    /**
     * Gets the latest service version supported by this client library.
     * 
     * @return The latest {@link DocumentIntelligenceServiceVersion}.
     */
    public static DocumentIntelligenceServiceVersion getLatest() {
        return V2024_11_30;
    }
}
