// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceAdministrationClientImpl;
import com.azure.ai.documentintelligence.models.AuthorizeClassifierCopyOptions;
import com.azure.ai.documentintelligence.models.AuthorizeModelCopyOptions;
import com.azure.ai.documentintelligence.models.BuildDocumentClassifierOptions;
import com.azure.ai.documentintelligence.models.BuildDocumentModelOptions;
import com.azure.ai.documentintelligence.models.ClassifierCopyAuthorization;
import com.azure.ai.documentintelligence.models.ComposeDocumentModelOptions;
import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceResourceDetails;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelDetails;
import com.azure.ai.documentintelligence.models.ModelCopyAuthorization;
import com.azure.core.annotation.Generated;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;

/**
 * Initializes a new instance of the synchronous DocumentIntelligenceAdministrationClient type.
 */
@ServiceClient(builder = DocumentIntelligenceAdministrationClientBuilder.class)
public final class DocumentIntelligenceAdministrationClient {

    @Generated
    private final DocumentIntelligenceAdministrationClientImpl serviceClient;

    /**
     * Initializes an instance of DocumentIntelligenceAdministrationClient class.
     *
     * @param serviceClient the service client implementation.
     */
    @Generated
    DocumentIntelligenceAdministrationClient(DocumentIntelligenceAdministrationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * Builds a custom document analysis model.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     buildMode: String(template/neural) (Required)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     maxTrainingHours: Double (Optional)
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     *
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildDocumentModel(BinaryData buildRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginBuildDocumentModel(buildRequest, requestOptions);
    }

    /**
     * Creates a new document model from document types of existing document models.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     classifierId: String (Required)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param composeRequest Compose request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginComposeModel(BinaryData composeRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginComposeModel(composeRequest, requestOptions);
    }

    /**
     * Generates authorization to copy a document model to this location with
     * specified modelId and optional description.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return authorization to copy a document model to the specified target resource and
     * modelId along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> authorizeModelCopyWithResponse(BinaryData authorizeCopyRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.authorizeModelCopyWithResponse(authorizeCopyRequest, requestOptions);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetModelId: String (Required)
     *     targetModelLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyModelTo(String modelId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginCopyModelTo(modelId, copyToRequest, requestOptions);
    }

    /**
     * Gets detailed document model information.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     *
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed document model information along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.getModelWithResponse(modelId, requestOptions);
    }

    /**
     * List all document models.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     modelId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     buildMode: String(template/neural) (Optional)
     *     azureBlobSource (Optional): {
     *         containerUrl: String (Required)
     *         prefix: String (Optional)
     *     }
     *     azureBlobFileListSource (Optional): {
     *         containerUrl: String (Required)
     *         fileList: String (Required)
     *     }
     *     classifierId: String (Optional)
     *     split: String(auto/none/perPage) (Optional)
     *     docTypes (Optional): {
     *         String (Required): {
     *             description: String (Optional)
     *             buildMode: String(template/neural) (Optional)
     *             fieldSchema (Optional): {
     *                 String (Required): {
     *                     type: String(string/date/time/phoneNumber/number/integer/selectionMark/countryRegion/signature/array/object/currency/address/boolean/selectionGroup) (Required)
     *                     description: String (Optional)
     *                     example: String (Optional)
     *                     items (Optional): (recursive schema, see items above)
     *                     properties (Optional): {
     *                         String (Required): (recursive schema, see String above)
     *                     }
     *                 }
     *             }
     *             fieldConfidence (Optional): {
     *                 String: double (Required)
     *             }
     *             modelId: String (Optional)
     *             confidenceThreshold: Double (Optional)
     *             features (Optional): [
     *                 String(ocrHighResolution/languages/barcodes/formulas/keyValuePairs/styleFont/queryFields) (Optional)
     *             ]
     *             queryFields (Optional): [
     *                 String (Optional)
     *             ]
     *             maxDocumentsToAnalyze: Integer (Optional)
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     *     trainingHours: Double (Optional)
     * }
     * }
     * </pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentModelDetails items as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listModels(RequestOptions requestOptions) {
        return this.serviceClient.listModels(requestOptions);
    }

    /**
     * Deletes document model.
     *
     * @param modelId Unique document model name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteModelWithResponse(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.deleteModelWithResponse(modelId, requestOptions);
    }

    /**
     * Return information about the current resource.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     customDocumentModels (Required): {
     *         count: int (Required)
     *         limit: int (Required)
     *     }
     * }
     * }
     * </pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return general information regarding the current resource along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getResourceDetailsWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getResourceDetailsWithResponse(requestOptions);
    }

    /**
     * Gets operation info.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     *
     * @param operationId Operation ID.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return operation info along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getOperationWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationWithResponse(operationId, requestOptions);
    }

    /**
     * Lists all operations.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     kind: String(documentModelBuild/documentModelCompose/documentModelCopyTo/documentClassifierCopyTo/documentClassifierBuild) (Required)
     *     operationId: String (Required)
     *     status: String(notStarted/running/failed/succeeded/canceled/skipped) (Required)
     *     percentCompleted: Integer (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     lastUpdatedDateTime: OffsetDateTime (Required)
     *     resourceLocation: String (Required)
     *     apiVersion: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     *     error (Optional): {
     *         code: String (Required)
     *         message: String (Required)
     *         target: String (Optional)
     *         details (Optional): [
     *             (recursive schema, see above)
     *         ]
     *         innererror (Optional): {
     *             code: String (Optional)
     *             message: String (Optional)
     *             innererror (Optional): (recursive schema, see innererror above)
     *         }
     *     }
     * }
     * }
     * </pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentIntelligenceOperationDetails items as paginated response with
     * {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperations(RequestOptions requestOptions) {
        return this.serviceClient.listOperations(requestOptions);
    }

    /**
     * Builds a custom document classifier.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     allowOverwrite: Boolean (Optional)
     * }
     * }
     * </pre>
     *
     * @param buildRequest Build request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginBuildClassifier(BinaryData buildRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginBuildClassifier(buildRequest, requestOptions);
    }

    /**
     * Generates authorization to copy a document classifier to this location with
     * specified classifierId and optional description.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     tags (Optional): {
     *         String: String (Required)
     *     }
     * }
     * }
     * </pre>
     * 
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return authorization to copy a document classifier to the specified target resource and
     * classifierId along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> authorizeClassifierCopyWithResponse(BinaryData authorizeCopyRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.authorizeClassifierCopyWithResponse(authorizeCopyRequest, requestOptions);
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     * <p><strong>Request Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     targetResourceId: String (Required)
     *     targetResourceRegion: String (Required)
     *     targetClassifierId: String (Required)
     *     targetClassifierLocation: String (Required)
     *     accessToken: String (Required)
     *     expirationDateTime: OffsetDateTime (Required)
     * }
     * }
     * </pre>
     *
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCopyClassifierTo(String classifierId, BinaryData copyToRequest,
        RequestOptions requestOptions) {
        return this.serviceClient.beginCopyClassifierTo(classifierId, copyToRequest, requestOptions);
    }

    /**
     * Gets detailed document classifier information.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     *
     * @param classifierId Unique document classifier name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return detailed document classifier information along with {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<BinaryData> getClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.getClassifierWithResponse(classifierId, requestOptions);
    }

    /**
     * List all document classifiers.
     * <p><strong>Response Body Schema</strong></p>
     * 
     * <pre>
     * {@code
     * {
     *     classifierId: String (Required)
     *     description: String (Optional)
     *     createdDateTime: OffsetDateTime (Required)
     *     expirationDateTime: OffsetDateTime (Optional)
     *     modifiedDateTime: OffsetDateTime (Optional)
     *     apiVersion: String (Required)
     *     baseClassifierId: String (Optional)
     *     docTypes (Required): {
     *         String (Required): {
     *             sourceKind: String(url/base64/azureBlob/azureBlobFileList) (Optional)
     *             azureBlobSource (Optional): {
     *                 containerUrl: String (Required)
     *                 prefix: String (Optional)
     *             }
     *             azureBlobFileListSource (Optional): {
     *                 containerUrl: String (Required)
     *                 fileList: String (Required)
     *             }
     *         }
     *     }
     *     warnings (Optional): [
     *          (Optional){
     *             code: String (Required)
     *             message: String (Required)
     *             target: String (Optional)
     *         }
     *     ]
     * }
     * }
     * </pre>
     *
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return paged collection of DocumentClassifierDetails items as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listClassifiers(RequestOptions requestOptions) {
        return this.serviceClient.listClassifiers(requestOptions);
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @param requestOptions The options to configure the HTTP request before HTTP client sends it.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @return the {@link Response}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteClassifierWithResponse(String classifierId, RequestOptions requestOptions) {
        return this.serviceClient.deleteClassifierWithResponse(classifierId, requestOptions);
    }

    /**
     * Builds a custom document analysis model.
     *
     * @param buildRequest Build request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelBuildOperationDetails, DocumentModelDetails>
        beginBuildDocumentModel(BuildDocumentModelOptions buildRequest) {
        // Generated convenience method for beginBuildDocumentModelWithModel
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.beginBuildDocumentModelWithModel(BinaryData.fromObject(buildRequest), requestOptions);
    }

    /**
     * Generates authorization to copy a document model to this location with
     * specified modelId and optional description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document model to the specified target resource and
     * modelId.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ModelCopyAuthorization authorizeModelCopy(AuthorizeModelCopyOptions authorizeCopyRequest) {
        // Generated convenience method for authorizeModelCopyWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return authorizeModelCopyWithResponse(BinaryData.fromObject(authorizeCopyRequest), requestOptions).getValue()
            .toObject(ModelCopyAuthorization.class);
    }

    /**
     * Copies document model to the target resource, region, and modelId.
     *
     * @param modelId Unique document model name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelCopyToOperationDetails, DocumentModelDetails> beginCopyModelTo(String modelId,
        ModelCopyAuthorization copyToRequest) {
        // Generated convenience method for beginCopyModelToWithModel
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.beginCopyModelToWithModel(modelId, BinaryData.fromObject(copyToRequest), requestOptions);
    }

    /**
     * Gets detailed document model information.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document model information.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentModelDetails getModel(String modelId) {
        // Generated convenience method for getModelWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getModelWithResponse(modelId, requestOptions).getValue().toObject(DocumentModelDetails.class);
    }

    /**
     * List all document models.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of DocumentModelDetails items as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentModelDetails> listModels() {
        // Generated convenience method for listModels
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.listModels(requestOptions)
            .mapPage(bodyItemValue -> bodyItemValue.toObject(DocumentModelDetails.class));
    }

    /**
     * Deletes document model.
     *
     * @param modelId Unique document model name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteModel(String modelId) {
        // Generated convenience method for deleteModelWithResponse
        RequestOptions requestOptions = new RequestOptions();
        deleteModelWithResponse(modelId, requestOptions).getValue();
    }

    /**
     * Return information about the current resource.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return general information regarding the current resource.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentIntelligenceResourceDetails getResourceDetails() {
        // Generated convenience method for getResourceDetailsWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getResourceDetailsWithResponse(requestOptions).getValue()
            .toObject(DocumentIntelligenceResourceDetails.class);
    }

    /**
     * Gets operation info.
     *
     * @param operationId Operation ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return operation info.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentIntelligenceOperationDetails getOperation(String operationId) {
        // Generated convenience method for getOperationWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getOperationWithResponse(operationId, requestOptions).getValue()
            .toObject(DocumentIntelligenceOperationDetails.class);
    }

    /**
     * Lists all operations.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of DocumentIntelligenceOperationDetails items as paginated response with
     * {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentIntelligenceOperationDetails> listOperations() {
        // Generated convenience method for listOperations
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.listOperations(requestOptions)
            .mapPage(bodyItemValue -> bodyItemValue.toObject(DocumentIntelligenceOperationDetails.class));
    }

    /**
     * Builds a custom document classifier.
     *
     * @param buildRequest Build request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierBuildOperationDetails, DocumentClassifierDetails>
        beginBuildClassifier(BuildDocumentClassifierOptions buildRequest) {
        // Generated convenience method for beginBuildClassifierWithModel
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.beginBuildClassifierWithModel(BinaryData.fromObject(buildRequest), requestOptions);
    }

    /**
     * Generates authorization to copy a document classifier to this location with
     * specified classifierId and optional description.
     *
     * @param authorizeCopyRequest Authorize copy request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return authorization to copy a document classifier to the specified target resource and
     * classifierId.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ClassifierCopyAuthorization authorizeClassifierCopy(AuthorizeClassifierCopyOptions authorizeCopyRequest) {
        // Generated convenience method for authorizeClassifierCopyWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return authorizeClassifierCopyWithResponse(BinaryData.fromObject(authorizeCopyRequest), requestOptions)
            .getValue()
            .toObject(ClassifierCopyAuthorization.class);
    }

    /**
     * Copies document classifier to the target resource, region, and classifierId.
     *
     * @param classifierId Unique document classifier name.
     * @param copyToRequest Copy to request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentClassifierCopyToOperationDetails, DocumentClassifierDetails>
        beginCopyClassifierTo(String classifierId, ClassifierCopyAuthorization copyToRequest) {
        // Generated convenience method for beginCopyClassifierToWithModel
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.beginCopyClassifierToWithModel(classifierId, BinaryData.fromObject(copyToRequest),
            requestOptions);
    }

    /**
     * Gets detailed document classifier information.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return detailed document classifier information.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DocumentClassifierDetails getClassifier(String classifierId) {
        // Generated convenience method for getClassifierWithResponse
        RequestOptions requestOptions = new RequestOptions();
        return getClassifierWithResponse(classifierId, requestOptions).getValue()
            .toObject(DocumentClassifierDetails.class);
    }

    /**
     * List all document classifiers.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return paged collection of DocumentClassifierDetails items as paginated response with {@link PagedIterable}.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DocumentClassifierDetails> listClassifiers() {
        // Generated convenience method for listClassifiers
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.listClassifiers(requestOptions)
            .mapPage(bodyItemValue -> bodyItemValue.toObject(DocumentClassifierDetails.class));
    }

    /**
     * Deletes document classifier.
     *
     * @param classifierId Unique document classifier name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteClassifier(String classifierId) {
        // Generated convenience method for deleteClassifierWithResponse
        RequestOptions requestOptions = new RequestOptions();
        deleteClassifierWithResponse(classifierId, requestOptions).getValue();
    }

    /**
     * Creates a new document model from document types of existing document models.
     *
     * @param composeRequest Compose request parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws ClientAuthenticationException thrown if the request is rejected by server on status code 401.
     * @throws ResourceNotFoundException thrown if the request is rejected by server on status code 404.
     * @throws ResourceModifiedException thrown if the request is rejected by server on status code 409.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @Generated
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DocumentModelComposeOperationDetails, DocumentModelDetails>
        beginComposeModel(ComposeDocumentModelOptions composeRequest) {
        // Generated convenience method for beginComposeModelWithModel
        RequestOptions requestOptions = new RequestOptions();
        return serviceClient.beginComposeModelWithModel(BinaryData.fromObject(composeRequest), requestOptions);
    }
}
