/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CurrencyValue
implements JsonSerializable<CurrencyValue> {
    private final double amount;
    private String currencySymbol;
    private String currencyCode;

    private CurrencyValue(double amount) {
        this.amount = amount;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("amount", this.amount);
        jsonWriter.writeStringField("currencySymbol", this.currencySymbol);
        jsonWriter.writeStringField("currencyCode", this.currencyCode);
        return jsonWriter.writeEndObject();
    }

    public static CurrencyValue fromJson(JsonReader jsonReader) throws IOException {
        return (CurrencyValue)jsonReader.readObject(reader -> {
            double amount = 0.0;
            String currencySymbol = null;
            String currencyCode = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("amount".equals(fieldName)) {
                    amount = reader.getDouble();
                    continue;
                }
                if ("currencySymbol".equals(fieldName)) {
                    currencySymbol = reader.getString();
                    continue;
                }
                if ("currencyCode".equals(fieldName)) {
                    currencyCode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            CurrencyValue deserializedCurrencyValue = new CurrencyValue(amount);
            deserializedCurrencyValue.currencySymbol = currencySymbol;
            deserializedCurrencyValue.currencyCode = currencyCode;
            return deserializedCurrencyValue;
        });
    }
}

