/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentBarcode;
import com.azure.ai.documentintelligence.models.DocumentFormula;
import com.azure.ai.documentintelligence.models.DocumentLine;
import com.azure.ai.documentintelligence.models.DocumentSelectionMark;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.ai.documentintelligence.models.DocumentWord;
import com.azure.ai.documentintelligence.models.LengthUnit;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentPage
implements JsonSerializable<DocumentPage> {
    private final int pageNumber;
    private Double angle;
    private Double width;
    private Double height;
    private LengthUnit unit;
    private final List<DocumentSpan> spans;
    private List<DocumentWord> words;
    private List<DocumentSelectionMark> selectionMarks;
    private List<DocumentLine> lines;
    private List<DocumentBarcode> barcodes;
    private List<DocumentFormula> formulas;

    private DocumentPage(int pageNumber, List<DocumentSpan> spans) {
        this.pageNumber = pageNumber;
        this.spans = spans;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Double getAngle() {
        return this.angle;
    }

    public Double getWidth() {
        return this.width;
    }

    public Double getHeight() {
        return this.height;
    }

    public LengthUnit getUnit() {
        return this.unit;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<DocumentWord> getWords() {
        return this.words;
    }

    public List<DocumentSelectionMark> getSelectionMarks() {
        return this.selectionMarks;
    }

    public List<DocumentLine> getLines() {
        return this.lines;
    }

    public List<DocumentBarcode> getBarcodes() {
        return this.barcodes;
    }

    public List<DocumentFormula> getFormulas() {
        return this.formulas;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("pageNumber", this.pageNumber);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("angle", (Number)this.angle);
        jsonWriter.writeNumberField("width", (Number)this.width);
        jsonWriter.writeNumberField("height", (Number)this.height);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("words", this.words, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("selectionMarks", this.selectionMarks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("lines", this.lines, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("barcodes", this.barcodes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("formulas", this.formulas, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentPage fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentPage)jsonReader.readObject(reader -> {
            int pageNumber = 0;
            List spans = null;
            Double angle = null;
            Double width = null;
            Double height = null;
            LengthUnit unit = null;
            List words = null;
            List selectionMarks = null;
            List lines = null;
            List barcodes = null;
            List formulas = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pageNumber".equals(fieldName)) {
                    pageNumber = reader.getInt();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("angle".equals(fieldName)) {
                    angle = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("width".equals(fieldName)) {
                    width = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("height".equals(fieldName)) {
                    height = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    unit = LengthUnit.fromString(reader.getString());
                    continue;
                }
                if ("words".equals(fieldName)) {
                    words = reader.readArray(reader1 -> DocumentWord.fromJson(reader1));
                    continue;
                }
                if ("selectionMarks".equals(fieldName)) {
                    selectionMarks = reader.readArray(reader1 -> DocumentSelectionMark.fromJson(reader1));
                    continue;
                }
                if ("lines".equals(fieldName)) {
                    lines = reader.readArray(reader1 -> DocumentLine.fromJson(reader1));
                    continue;
                }
                if ("barcodes".equals(fieldName)) {
                    barcodes = reader.readArray(reader1 -> DocumentBarcode.fromJson(reader1));
                    continue;
                }
                if ("formulas".equals(fieldName)) {
                    formulas = reader.readArray(reader1 -> DocumentFormula.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            DocumentPage deserializedDocumentPage = new DocumentPage(pageNumber, spans);
            deserializedDocumentPage.angle = angle;
            deserializedDocumentPage.width = width;
            deserializedDocumentPage.height = height;
            deserializedDocumentPage.unit = unit;
            deserializedDocumentPage.words = words;
            deserializedDocumentPage.selectionMarks = selectionMarks;
            deserializedDocumentPage.lines = lines;
            deserializedDocumentPage.barcodes = barcodes;
            deserializedDocumentPage.formulas = formulas;
            return deserializedDocumentPage;
        });
    }
}

