/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentFieldType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class DocumentFieldSchema
implements JsonSerializable<DocumentFieldSchema> {
    private final DocumentFieldType type;
    private String description;
    private String example;
    private DocumentFieldSchema items;
    private Map<String, DocumentFieldSchema> properties;

    public DocumentFieldSchema(DocumentFieldType type) {
        this.type = type;
    }

    public DocumentFieldType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentFieldSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getExample() {
        return this.example;
    }

    public DocumentFieldSchema setExample(String example) {
        this.example = example;
        return this;
    }

    public DocumentFieldSchema getItems() {
        return this.items;
    }

    public DocumentFieldSchema setItems(DocumentFieldSchema items) {
        this.items = items;
        return this;
    }

    public Map<String, DocumentFieldSchema> getProperties() {
        return this.properties;
    }

    public DocumentFieldSchema setProperties(Map<String, DocumentFieldSchema> properties) {
        this.properties = properties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("example", this.example);
        jsonWriter.writeJsonField("items", (JsonSerializable)this.items);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentFieldSchema fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentFieldSchema)jsonReader.readObject(reader -> {
            DocumentFieldType type = null;
            String description = null;
            String example = null;
            DocumentFieldSchema items = null;
            Map properties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    type = DocumentFieldType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("example".equals(fieldName)) {
                    example = reader.getString();
                    continue;
                }
                if ("items".equals(fieldName)) {
                    items = DocumentFieldSchema.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    properties = reader.readMap(reader1 -> DocumentFieldSchema.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            DocumentFieldSchema deserializedDocumentFieldSchema = new DocumentFieldSchema(type);
            deserializedDocumentFieldSchema.description = description;
            deserializedDocumentFieldSchema.example = example;
            deserializedDocumentFieldSchema.items = items;
            deserializedDocumentFieldSchema.properties = properties;
            return deserializedDocumentFieldSchema;
        });
    }
}

