/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BoundingRegion
implements JsonSerializable<BoundingRegion> {
    private final int pageNumber;
    private final List<Double> polygon;

    private BoundingRegion(int pageNumber, List<Double> polygon) {
        this.pageNumber = pageNumber;
        this.polygon = polygon;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public List<Double> getPolygon() {
        return this.polygon;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("pageNumber", this.pageNumber);
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static BoundingRegion fromJson(JsonReader jsonReader) throws IOException {
        return (BoundingRegion)jsonReader.readObject(reader -> {
            int pageNumber = 0;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pageNumber".equals(fieldName)) {
                    pageNumber = reader.getInt();
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                    continue;
                }
                reader.skipChildren();
            }
            return new BoundingRegion(pageNumber, polygon);
        });
    }
}

