/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceClientBuilder;
import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceClientImpl;
import com.azure.ai.documentintelligence.models.AnalyzeBatchDocumentsOptions;
import com.azure.ai.documentintelligence.models.AnalyzeBatchOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeBatchResult;
import com.azure.ai.documentintelligence.models.AnalyzeDocumentOptions;
import com.azure.ai.documentintelligence.models.AnalyzeOperationDetails;
import com.azure.ai.documentintelligence.models.AnalyzeOutputFormat;
import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.ai.documentintelligence.models.ClassifyDocumentOptions;
import com.azure.ai.documentintelligence.models.DocumentAnalysisFeature;
import com.azure.ai.documentintelligence.models.DocumentContentFormat;
import com.azure.ai.documentintelligence.models.SplitMode;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DocumentIntelligenceClientBuilder.class, isAsync=true)
public final class DocumentIntelligenceAsyncClient {
    private final DocumentIntelligenceClientImpl serviceClient;

    DocumentIntelligenceAsyncClient(DocumentIntelligenceClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultPdfWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeResultPdfWithResponseAsync(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeResultFigureWithResponse(String modelId, String resultId, String figureId, RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeResultFigureWithResponseAsync(modelId, resultId, figureId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnalyzeResultWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.deleteAnalyzeResultWithResponseAsync(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAnalyzeBatchResults(String modelId, RequestOptions requestOptions) {
        return this.serviceClient.listAnalyzeBatchResultsAsync(modelId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnalyzeBatchResultWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.deleteAnalyzeBatchResultWithResponseAsync(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAnalyzeBatchResultWithResponse(String modelId, String resultId, RequestOptions requestOptions) {
        return this.serviceClient.getAnalyzeBatchResultWithResponseAsync(modelId, resultId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocument(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginClassifyDocumentAsync(classifierId, classifyRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocument(String modelId, AnalyzeDocumentOptions analyzeDocumentOptions) {
        Objects.requireNonNull(analyzeDocumentOptions, "'analyzeDocumentOptions' cannot be null.");
        return this.beginAnalyzeDocument(modelId, analyzeDocumentOptions, analyzeDocumentOptions.getPages() != null ? CoreUtils.stringJoin((String)",", analyzeDocumentOptions.getPages()) : null, analyzeDocumentOptions.getLocale(), analyzeDocumentOptions.getStringIndexType(), analyzeDocumentOptions.getDocumentAnalysisFeatures(), analyzeDocumentOptions.getQueryFields(), analyzeDocumentOptions.getOutputContentFormat(), analyzeDocumentOptions.getOutput());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getAnalyzeResultPdf(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAnalyzeResultPdfWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getAnalyzeResultFigure(String modelId, String resultId, String figureId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAnalyzeResultFigureWithResponse(modelId, resultId, figureId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAnalyzeResult(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteAnalyzeResultWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocuments(String modelId, AnalyzeBatchDocumentsOptions analyzeBatchDocumentOptions) {
        Objects.requireNonNull(analyzeBatchDocumentOptions, "'analyzeBatchDocumentOptions' cannot be null.");
        return this.beginAnalyzeBatchDocuments(modelId, analyzeBatchDocumentOptions, analyzeBatchDocumentOptions.getPages() != null ? CoreUtils.stringJoin((String)",", analyzeBatchDocumentOptions.getPages()) : null, analyzeBatchDocumentOptions.getLocale(), analyzeBatchDocumentOptions.getStringIndexType(), analyzeBatchDocumentOptions.getDocumentAnalysisFeatures(), analyzeBatchDocumentOptions.getQueryFields(), analyzeBatchDocumentOptions.getOutputContentFormat(), analyzeBatchDocumentOptions.getOutput());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AnalyzeBatchOperationDetails> listAnalyzeBatchResults(String modelId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listAnalyzeBatchResults(modelId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (AnalyzeBatchOperationDetails)protocolMethodData.toObject(AnalyzeBatchOperationDetails.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAnalyzeBatchResult(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnalyzeBatchOperationDetails> getAnalyzeBatchResult(String modelId, String resultId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAnalyzeBatchResultWithResponse(modelId, resultId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AnalyzeBatchOperationDetails)protocolMethodData.toObject(AnalyzeBatchOperationDetails.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocument(String classifierId, ClassifyDocumentOptions classifyDocumentOptions) {
        Objects.requireNonNull(classifyDocumentOptions, "'classifyDocumentOptions' cannot be null.");
        return this.beginClassifyDocument(classifierId, classifyDocumentOptions, classifyDocumentOptions.getStringIndexType(), classifyDocumentOptions.getSplit(), classifyDocumentOptions.getPages() != null ? CoreUtils.stringJoin((String)",", classifyDocumentOptions.getPages()) : null);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, BinaryData analyzeRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginAnalyzeDocumentAsync(modelId, analyzeRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeBatchDocuments(String modelId, BinaryData analyzeBatchRequest, RequestOptions requestOptions) {
        return this.serviceClient.beginAnalyzeBatchDocumentsAsync(modelId, analyzeBatchRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginAnalyzeDocument(String modelId, AnalyzeDocumentOptions analyzeRequest, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, List<String> queryFields, DocumentContentFormat outputContentFormat, List<AnalyzeOutputFormat> output) {
        RequestOptions requestOptions = new RequestOptions();
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        if (locale != null) {
            requestOptions.addQueryParam("locale", locale, false);
        }
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (features != null) {
            requestOptions.addQueryParam("features", features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (queryFields != null) {
            requestOptions.addQueryParam("queryFields", queryFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (outputContentFormat != null) {
            requestOptions.addQueryParam("outputContentFormat", outputContentFormat.toString(), false);
        }
        if (output != null) {
            requestOptions.addQueryParam("output", output.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.beginAnalyzeDocumentWithModelAsync(modelId, BinaryData.fromObject((Object)analyzeRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<AnalyzeBatchOperationDetails, AnalyzeBatchResult> beginAnalyzeBatchDocuments(String modelId, AnalyzeBatchDocumentsOptions analyzeBatchRequest, String pages, String locale, StringIndexType stringIndexType, List<DocumentAnalysisFeature> features, List<String> queryFields, DocumentContentFormat outputContentFormat, List<AnalyzeOutputFormat> output) {
        RequestOptions requestOptions = new RequestOptions();
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        if (locale != null) {
            requestOptions.addQueryParam("locale", locale, false);
        }
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (features != null) {
            requestOptions.addQueryParam("features", features.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (queryFields != null) {
            requestOptions.addQueryParam("queryFields", queryFields.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (outputContentFormat != null) {
            requestOptions.addQueryParam("outputContentFormat", outputContentFormat.toString(), false);
        }
        if (output != null) {
            requestOptions.addQueryParam("output", output.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.beginAnalyzeBatchDocumentsWithModelAsync(modelId, BinaryData.fromObject((Object)analyzeBatchRequest), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<AnalyzeOperationDetails, AnalyzeResult> beginClassifyDocument(String classifierId, ClassifyDocumentOptions classifyRequest, StringIndexType stringIndexType, SplitMode split, String pages) {
        RequestOptions requestOptions = new RequestOptions();
        if (stringIndexType != null) {
            requestOptions.addQueryParam("stringIndexType", stringIndexType.toString(), false);
        }
        if (split != null) {
            requestOptions.addQueryParam("split", split.toString(), false);
        }
        if (pages != null) {
            requestOptions.addQueryParam("pages", pages, false);
        }
        return this.serviceClient.beginClassifyDocumentWithModelAsync(classifierId, BinaryData.fromObject((Object)classifyRequest), requestOptions);
    }
}

