/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.DocumentCaption;
import com.azure.ai.documentintelligence.models.DocumentFootnote;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentFigure
implements JsonSerializable<DocumentFigure> {
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;
    private List<String> elements;
    private DocumentCaption caption;
    private List<DocumentFootnote> footnotes;
    private String id;

    private DocumentFigure(List<DocumentSpan> spans) {
        this.spans = spans;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public DocumentCaption getCaption() {
        return this.caption;
    }

    public List<DocumentFootnote> getFootnotes() {
        return this.footnotes;
    }

    public String getId() {
        return this.id;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("caption", (JsonSerializable)this.caption);
        jsonWriter.writeArrayField("footnotes", this.footnotes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static DocumentFigure fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentFigure)jsonReader.readObject(reader -> {
            List spans = null;
            List boundingRegions = null;
            List elements = null;
            DocumentCaption caption = null;
            List footnotes = null;
            String id = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("caption".equals(fieldName)) {
                    caption = DocumentCaption.fromJson(reader);
                    continue;
                }
                if ("footnotes".equals(fieldName)) {
                    footnotes = reader.readArray(reader1 -> DocumentFootnote.fromJson(reader1));
                    continue;
                }
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            DocumentFigure deserializedDocumentFigure = new DocumentFigure(spans);
            deserializedDocumentFigure.boundingRegions = boundingRegions;
            deserializedDocumentFigure.elements = elements;
            deserializedDocumentFigure.caption = caption;
            deserializedDocumentFigure.footnotes = footnotes;
            deserializedDocumentFigure.id = id;
            return deserializedDocumentFigure;
        });
    }
}

