/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.ClassifierDocumentTypeDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceWarning;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class DocumentClassifierDetails
implements JsonSerializable<DocumentClassifierDetails> {
    private String classifierId;
    private String description;
    private final OffsetDateTime createdOn;
    private OffsetDateTime expiresOn;
    private OffsetDateTime modifiedOn;
    private final String apiVersion;
    private String baseClassifierId;
    private final Map<String, ClassifierDocumentTypeDetails> documentTypes;
    private List<DocumentIntelligenceWarning> warnings;

    private DocumentClassifierDetails(OffsetDateTime createdOn, String apiVersion, Map<String, ClassifierDocumentTypeDetails> documentTypes) {
        this.createdOn = createdOn;
        this.apiVersion = apiVersion;
        this.documentTypes = documentTypes;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public String getDescription() {
        return this.description;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public OffsetDateTime getModifiedOn() {
        return this.modifiedOn;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getBaseClassifierId() {
        return this.baseClassifierId;
    }

    public Map<String, ClassifierDocumentTypeDetails> getDocumentTypes() {
        return this.documentTypes;
    }

    public List<DocumentIntelligenceWarning> getWarnings() {
        return this.warnings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("docTypes", this.documentTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("expirationDateTime", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        jsonWriter.writeStringField("baseClassifierId", this.baseClassifierId);
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentClassifierDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentClassifierDetails)jsonReader.readObject(reader -> {
            String classifierId = null;
            OffsetDateTime createdOn = null;
            String apiVersion = null;
            Map documentTypes = null;
            String description = null;
            OffsetDateTime expiresOn = null;
            OffsetDateTime modifiedOn = null;
            String baseClassifierId = null;
            List warnings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    documentTypes = reader.readMap(reader1 -> ClassifierDocumentTypeDetails.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("modifiedDateTime".equals(fieldName)) {
                    modifiedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("baseClassifierId".equals(fieldName)) {
                    baseClassifierId = reader.getString();
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    warnings = reader.readArray(reader1 -> DocumentIntelligenceWarning.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            DocumentClassifierDetails deserializedDocumentClassifierDetails = new DocumentClassifierDetails(createdOn, apiVersion, documentTypes);
            deserializedDocumentClassifierDetails.classifierId = classifierId;
            deserializedDocumentClassifierDetails.description = description;
            deserializedDocumentClassifierDetails.expiresOn = expiresOn;
            deserializedDocumentClassifierDetails.modifiedOn = modifiedOn;
            deserializedDocumentClassifierDetails.baseClassifierId = baseClassifierId;
            deserializedDocumentClassifierDetails.warnings = warnings;
            return deserializedDocumentClassifierDetails;
        });
    }
}

