/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence;

import com.azure.ai.documentintelligence.DocumentIntelligenceAsyncClient;
import com.azure.ai.documentintelligence.DocumentIntelligenceClient;
import com.azure.ai.documentintelligence.DocumentIntelligenceServiceVersion;
import com.azure.ai.documentintelligence.implementation.DocumentIntelligenceClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.KeyCredentialTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.KeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.KeyCredentialPolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DocumentIntelligenceClient.class, DocumentIntelligenceAsyncClient.class})
public final class DocumentIntelligenceClientBuilder
implements HttpTrait<DocumentIntelligenceClientBuilder>,
ConfigurationTrait<DocumentIntelligenceClientBuilder>,
TokenCredentialTrait<DocumentIntelligenceClientBuilder>,
KeyCredentialTrait<DocumentIntelligenceClientBuilder>,
EndpointTrait<DocumentIntelligenceClientBuilder> {
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String[] DEFAULT_SCOPES = new String[]{"https://cognitiveservices.azure.com/.default"};
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-ai-documentintelligence.properties");
    private final List<HttpPipelinePolicy> pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpPipeline pipeline;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private KeyCredential keyCredential;
    private String endpoint;
    private DocumentIntelligenceServiceVersion serviceVersion;
    private RetryPolicy retryPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(DocumentIntelligenceClientBuilder.class);

    public DocumentIntelligenceClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.atInfo().log("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public DocumentIntelligenceClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public DocumentIntelligenceClientBuilder httpLogOptions(HttpLogOptions httpLogOptions) {
        this.httpLogOptions = httpLogOptions;
        return this;
    }

    public DocumentIntelligenceClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public DocumentIntelligenceClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public DocumentIntelligenceClientBuilder addPolicy(HttpPipelinePolicy customPolicy) {
        Objects.requireNonNull(customPolicy, "'customPolicy' cannot be null.");
        this.pipelinePolicies.add(customPolicy);
        return this;
    }

    public DocumentIntelligenceClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public DocumentIntelligenceClientBuilder credential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
        return this;
    }

    public DocumentIntelligenceClientBuilder credential(KeyCredential keyCredential) {
        this.keyCredential = keyCredential;
        return this;
    }

    public DocumentIntelligenceClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public DocumentIntelligenceClientBuilder serviceVersion(DocumentIntelligenceServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public DocumentIntelligenceClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    private DocumentIntelligenceClientImpl buildInnerClient() {
        this.validateClient();
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : this.createHttpPipeline();
        DocumentIntelligenceServiceVersion localServiceVersion = this.serviceVersion != null ? this.serviceVersion : DocumentIntelligenceServiceVersion.getLatest();
        DocumentIntelligenceClientImpl client = new DocumentIntelligenceClientImpl(localPipeline, JacksonAdapter.createDefaultSerializerAdapter(), this.endpoint, localServiceVersion);
        return client;
    }

    private void validateClient() {
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
    }

    private HttpPipeline createHttpPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpLogOptions localHttpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions == null ? new ClientOptions() : this.clientOptions;
        ArrayList<Object> policies = new ArrayList<Object>();
        String clientName = PROPERTIES.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)localClientOptions, (HttpLogOptions)localHttpLogOptions);
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersFromContextPolicy());
        HttpHeaders headers = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)localClientOptions);
        if (headers != null) {
            policies.add(new AddHeadersPolicy(headers));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).forEach(p -> policies.add(p));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)new RetryPolicy()));
        policies.add(new AddDatePolicy());
        if (this.keyCredential != null) {
            policies.add(new KeyCredentialPolicy("Ocp-Apim-Subscription-Key", this.keyCredential));
        }
        if (this.tokenCredential != null) {
            policies.add(new BearerTokenAuthenticationPolicy(this.tokenCredential, DEFAULT_SCOPES));
        }
        this.pipelinePolicies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).forEach(p -> policies.add(p));
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(localHttpLogOptions));
        HttpPipeline httpPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).build();
        return httpPipeline;
    }

    public DocumentIntelligenceAsyncClient buildAsyncClient() {
        return new DocumentIntelligenceAsyncClient(this.buildInnerClient());
    }

    public DocumentIntelligenceClient buildClient() {
        return new DocumentIntelligenceClient(this.buildInnerClient());
    }
}

