/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.DocumentCaption;
import com.azure.ai.documentintelligence.models.DocumentFootnote;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.ai.documentintelligence.models.DocumentTableCell;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentTable
implements JsonSerializable<DocumentTable> {
    private final int rowCount;
    private final int columnCount;
    private final List<DocumentTableCell> cells;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;
    private DocumentCaption caption;
    private List<DocumentFootnote> footnotes;

    private DocumentTable(int rowCount, int columnCount, List<DocumentTableCell> cells, List<DocumentSpan> spans) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.cells = cells;
        this.spans = spans;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public List<DocumentTableCell> getCells() {
        return this.cells;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public DocumentCaption getCaption() {
        return this.caption;
    }

    public List<DocumentFootnote> getFootnotes() {
        return this.footnotes;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("rowCount", this.rowCount);
        jsonWriter.writeIntField("columnCount", this.columnCount);
        jsonWriter.writeArrayField("cells", this.cells, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("caption", (JsonSerializable)this.caption);
        jsonWriter.writeArrayField("footnotes", this.footnotes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentTable fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentTable)jsonReader.readObject(reader -> {
            int rowCount = 0;
            int columnCount = 0;
            List cells = null;
            List spans = null;
            List boundingRegions = null;
            DocumentCaption caption = null;
            List footnotes = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rowCount".equals(fieldName)) {
                    rowCount = reader.getInt();
                    continue;
                }
                if ("columnCount".equals(fieldName)) {
                    columnCount = reader.getInt();
                    continue;
                }
                if ("cells".equals(fieldName)) {
                    cells = reader.readArray(reader1 -> DocumentTableCell.fromJson(reader1));
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("caption".equals(fieldName)) {
                    caption = DocumentCaption.fromJson(reader);
                    continue;
                }
                if ("footnotes".equals(fieldName)) {
                    footnotes = reader.readArray(reader1 -> DocumentFootnote.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            DocumentTable deserializedDocumentTable = new DocumentTable(rowCount, columnCount, cells, spans);
            deserializedDocumentTable.boundingRegions = boundingRegions;
            deserializedDocumentTable.caption = caption;
            deserializedDocumentTable.footnotes = footnotes;
            return deserializedDocumentTable;
        });
    }
}

