/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.ai.documentintelligence.models.ParagraphRole;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentParagraph
implements JsonSerializable<DocumentParagraph> {
    private ParagraphRole role;
    private final String content;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;

    private DocumentParagraph(String content, List<DocumentSpan> spans) {
        this.content = content;
        this.spans = spans;
    }

    public ParagraphRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentParagraph fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentParagraph)jsonReader.readObject(reader -> {
            String content = null;
            List spans = null;
            ParagraphRole role = null;
            List boundingRegions = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("role".equals(fieldName)) {
                    role = ParagraphRole.fromString(reader.getString());
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            DocumentParagraph deserializedDocumentParagraph = new DocumentParagraph(content, spans);
            deserializedDocumentParagraph.role = role;
            deserializedDocumentParagraph.boundingRegions = boundingRegions;
            return deserializedDocumentParagraph;
        });
    }
}

