/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.BoundingRegion;
import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentListItem
implements JsonSerializable<DocumentListItem> {
    private final int level;
    private final String content;
    private List<BoundingRegion> boundingRegions;
    private final List<DocumentSpan> spans;
    private List<String> elements;

    private DocumentListItem(int level, String content, List<DocumentSpan> spans) {
        this.level = level;
        this.content = content;
        this.spans = spans;
    }

    public int getLevel() {
        return this.level;
    }

    public String getContent() {
        return this.content;
    }

    public List<BoundingRegion> getBoundingRegions() {
        return this.boundingRegions;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("level", this.level);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("boundingRegions", this.boundingRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("elements", this.elements, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentListItem fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentListItem)jsonReader.readObject(reader -> {
            int level = 0;
            String content = null;
            List spans = null;
            List boundingRegions = null;
            List elements = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("level".equals(fieldName)) {
                    level = reader.getInt();
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("boundingRegions".equals(fieldName)) {
                    boundingRegions = reader.readArray(reader1 -> BoundingRegion.fromJson(reader1));
                    continue;
                }
                if ("elements".equals(fieldName)) {
                    elements = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentListItem deserializedDocumentListItem = new DocumentListItem(level, content, spans);
            deserializedDocumentListItem.boundingRegions = boundingRegions;
            deserializedDocumentListItem.elements = elements;
            return deserializedDocumentListItem;
        });
    }
}

