/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ComponentDocumentModelDetails
implements JsonSerializable<ComponentDocumentModelDetails> {
    private String docType;
    private final String modelId;
    private Integer maxDocumentsToAnalyze;

    public ComponentDocumentModelDetails(String modelId) {
        this.modelId = modelId;
    }

    public String getDocType() {
        return this.docType;
    }

    public ComponentDocumentModelDetails setDocType(String docType) {
        this.docType = docType;
        return this;
    }

    public String getModelId() {
        return this.modelId;
    }

    public Integer getMaxDocumentsToAnalyze() {
        return this.maxDocumentsToAnalyze;
    }

    public ComponentDocumentModelDetails setMaxDocumentsToAnalyze(Integer maxDocumentsToAnalyze) {
        this.maxDocumentsToAnalyze = maxDocumentsToAnalyze;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeStringField("docType", this.docType);
        jsonWriter.writeNumberField("maxDocumentsToAnalyze", (Number)this.maxDocumentsToAnalyze);
        return jsonWriter.writeEndObject();
    }

    public static ComponentDocumentModelDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ComponentDocumentModelDetails)jsonReader.readObject(reader -> {
            String modelId = null;
            String docType = null;
            Integer maxDocumentsToAnalyze = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("docType".equals(fieldName)) {
                    docType = reader.getString();
                    continue;
                }
                if ("maxDocumentsToAnalyze".equals(fieldName)) {
                    maxDocumentsToAnalyze = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            ComponentDocumentModelDetails deserializedComponentDocumentModelDetails = new ComponentDocumentModelDetails(modelId);
            deserializedComponentDocumentModelDetails.docType = docType;
            deserializedComponentDocumentModelDetails.maxDocumentsToAnalyze = maxDocumentsToAnalyze;
            return deserializedComponentDocumentModelDetails;
        });
    }
}

