/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.ai.documentintelligence.models.Error;
import com.azure.ai.documentintelligence.models.OperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AnalyzeResultOperation
implements JsonSerializable<AnalyzeResultOperation> {
    private final OperationStatus status;
    private final OffsetDateTime createdDateTime;
    private final OffsetDateTime lastUpdatedDateTime;
    private Error error;
    private AnalyzeResult analyzeResult;
    private String operationId;

    private AnalyzeResultOperation(OperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime) {
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Error getError() {
        return this.error;
    }

    public AnalyzeResult getAnalyzeResult() {
        return this.analyzeResult;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("analyzeResult", (JsonSerializable)this.analyzeResult);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeResultOperation fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeResultOperation)jsonReader.readObject(reader -> {
            OperationStatus status = null;
            OffsetDateTime createdDateTime = null;
            OffsetDateTime lastUpdatedDateTime = null;
            Error error = null;
            AnalyzeResult analyzeResult = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                if ("analyzeResult".equals(fieldName)) {
                    analyzeResult = AnalyzeResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeResultOperation deserializedAnalyzeResultOperation = new AnalyzeResultOperation(status, createdDateTime, lastUpdatedDateTime);
            deserializedAnalyzeResultOperation.error = error;
            deserializedAnalyzeResultOperation.analyzeResult = analyzeResult;
            return deserializedAnalyzeResultOperation;
        });
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }
}

