/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AnalyzeBatchResult;
import com.azure.ai.documentintelligence.models.Error;
import com.azure.ai.documentintelligence.models.OperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AnalyzeBatchResultOperation
implements JsonSerializable<AnalyzeBatchResultOperation> {
    private final OperationStatus status;
    private final OffsetDateTime createdDateTime;
    private final OffsetDateTime lastUpdatedDateTime;
    private Integer percentCompleted;
    private Error error;
    private AnalyzeBatchResult result;

    private AnalyzeBatchResultOperation(OperationStatus status, OffsetDateTime createdDateTime, OffsetDateTime lastUpdatedDateTime) {
        this.status = status;
        this.createdDateTime = createdDateTime;
        this.lastUpdatedDateTime = lastUpdatedDateTime;
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getLastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    public Error getError() {
        return this.error;
    }

    public AnalyzeBatchResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeNumberField("percentCompleted", (Number)this.percentCompleted);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("result", (JsonSerializable)this.result);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeBatchResultOperation fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeBatchResultOperation)jsonReader.readObject(reader -> {
            OperationStatus status = null;
            OffsetDateTime createdDateTime = null;
            OffsetDateTime lastUpdatedDateTime = null;
            Integer percentCompleted = null;
            Error error = null;
            AnalyzeBatchResult result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = OperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = Error.fromJson(reader);
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = AnalyzeBatchResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeBatchResultOperation deserializedAnalyzeBatchResultOperation = new AnalyzeBatchResultOperation(status, createdDateTime, lastUpdatedDateTime);
            deserializedAnalyzeBatchResultOperation.percentCompleted = percentCompleted;
            deserializedAnalyzeBatchResultOperation.error = error;
            deserializedAnalyzeBatchResultOperation.result = result;
            return deserializedAnalyzeBatchResultOperation;
        });
    }
}

