/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AzureBlobContentSource;
import com.azure.ai.documentintelligence.models.AzureBlobFileListContentSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AnalyzeBatchDocumentsRequest
implements JsonSerializable<AnalyzeBatchDocumentsRequest> {
    private AzureBlobContentSource azureBlobSource;
    private AzureBlobFileListContentSource azureBlobFileListSource;
    private final String resultContainerUrl;
    private String resultPrefix;
    private Boolean overwriteExisting;

    public AnalyzeBatchDocumentsRequest(String resultContainerUrl) {
        this.resultContainerUrl = resultContainerUrl;
    }

    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    public AnalyzeBatchDocumentsRequest setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    public AnalyzeBatchDocumentsRequest setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }

    public String getResultContainerUrl() {
        return this.resultContainerUrl;
    }

    public String getResultPrefix() {
        return this.resultPrefix;
    }

    public AnalyzeBatchDocumentsRequest setResultPrefix(String resultPrefix) {
        this.resultPrefix = resultPrefix;
        return this;
    }

    public Boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }

    public AnalyzeBatchDocumentsRequest setOverwriteExisting(Boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultContainerUrl", this.resultContainerUrl);
        jsonWriter.writeJsonField("azureBlobSource", (JsonSerializable)this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", (JsonSerializable)this.azureBlobFileListSource);
        jsonWriter.writeStringField("resultPrefix", this.resultPrefix);
        jsonWriter.writeBooleanField("overwriteExisting", this.overwriteExisting);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeBatchDocumentsRequest fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeBatchDocumentsRequest)jsonReader.readObject(reader -> {
            String resultContainerUrl = null;
            AzureBlobContentSource azureBlobSource = null;
            AzureBlobFileListContentSource azureBlobFileListSource = null;
            String resultPrefix = null;
            Boolean overwriteExisting = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resultContainerUrl".equals(fieldName)) {
                    resultContainerUrl = reader.getString();
                    continue;
                }
                if ("azureBlobSource".equals(fieldName)) {
                    azureBlobSource = AzureBlobContentSource.fromJson(reader);
                    continue;
                }
                if ("azureBlobFileListSource".equals(fieldName)) {
                    azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                    continue;
                }
                if ("resultPrefix".equals(fieldName)) {
                    resultPrefix = reader.getString();
                    continue;
                }
                if ("overwriteExisting".equals(fieldName)) {
                    overwriteExisting = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeBatchDocumentsRequest deserializedAnalyzeBatchDocumentsRequest = new AnalyzeBatchDocumentsRequest(resultContainerUrl);
            deserializedAnalyzeBatchDocumentsRequest.azureBlobSource = azureBlobSource;
            deserializedAnalyzeBatchDocumentsRequest.azureBlobFileListSource = azureBlobFileListSource;
            deserializedAnalyzeBatchDocumentsRequest.resultPrefix = resultPrefix;
            deserializedAnalyzeBatchDocumentsRequest.overwriteExisting = overwriteExisting;
            return deserializedAnalyzeBatchDocumentsRequest;
        });
    }
}

