/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AzureBlobContentSource;
import com.azure.ai.documentintelligence.models.AzureBlobFileListContentSource;
import com.azure.ai.documentintelligence.models.DocumentBuildMode;
import com.azure.ai.documentintelligence.models.DocumentTypeDetails;
import com.azure.ai.documentintelligence.models.Warning;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class DocumentModelDetails
implements JsonSerializable<DocumentModelDetails> {
    private String modelId;
    private String description;
    private final OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private String apiVersion;
    private Map<String, String> tags;
    private DocumentBuildMode buildMode;
    private AzureBlobContentSource azureBlobSource;
    private AzureBlobFileListContentSource azureBlobFileListSource;
    private Map<String, DocumentTypeDetails> docTypes;
    private List<Warning> warnings;

    private DocumentModelDetails(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    public Map<String, DocumentTypeDetails> getDocTypes() {
        return this.docTypes;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("buildMode", this.buildMode == null ? null : this.buildMode.toString());
        jsonWriter.writeJsonField("azureBlobSource", (JsonSerializable)this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", (JsonSerializable)this.azureBlobFileListSource);
        jsonWriter.writeMapField("docTypes", this.docTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DocumentModelDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentModelDetails)jsonReader.readObject(reader -> {
            String modelId = null;
            OffsetDateTime createdDateTime = null;
            String description = null;
            OffsetDateTime expirationDateTime = null;
            String apiVersion = null;
            Map tags = null;
            DocumentBuildMode buildMode = null;
            AzureBlobContentSource azureBlobSource = null;
            AzureBlobFileListContentSource azureBlobFileListSource = null;
            Map docTypes = null;
            List warnings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    modelId = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("buildMode".equals(fieldName)) {
                    buildMode = DocumentBuildMode.fromString(reader.getString());
                    continue;
                }
                if ("azureBlobSource".equals(fieldName)) {
                    azureBlobSource = AzureBlobContentSource.fromJson(reader);
                    continue;
                }
                if ("azureBlobFileListSource".equals(fieldName)) {
                    azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    docTypes = reader.readMap(reader1 -> DocumentTypeDetails.fromJson(reader1));
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    warnings = reader.readArray(reader1 -> Warning.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            DocumentModelDetails deserializedDocumentModelDetails = new DocumentModelDetails(createdDateTime);
            deserializedDocumentModelDetails.modelId = modelId;
            deserializedDocumentModelDetails.description = description;
            deserializedDocumentModelDetails.expirationDateTime = expirationDateTime;
            deserializedDocumentModelDetails.apiVersion = apiVersion;
            deserializedDocumentModelDetails.tags = tags;
            deserializedDocumentModelDetails.buildMode = buildMode;
            deserializedDocumentModelDetails.azureBlobSource = azureBlobSource;
            deserializedDocumentModelDetails.azureBlobFileListSource = azureBlobFileListSource;
            deserializedDocumentModelDetails.docTypes = docTypes;
            deserializedDocumentModelDetails.warnings = warnings;
            return deserializedDocumentModelDetails;
        });
    }
}

