/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.implementation;

import com.azure.ai.documentintelligence.DocumentIntelligenceServiceVersion;
import com.azure.ai.documentintelligence.models.AnalyzeResultOperation;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import reactor.core.publisher.Mono;

public final class DocumentIntelligenceClientImpl {
    private final DocumentIntelligenceClientService service;
    private final String endpoint;
    private final DocumentIntelligenceServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public DocumentIntelligenceServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DocumentIntelligenceClientImpl(String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DocumentIntelligenceClientImpl(HttpPipeline httpPipeline, String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DocumentIntelligenceClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, DocumentIntelligenceServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (DocumentIntelligenceClientService)RestProxy.create(DocumentIntelligenceClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> analyzeDocumentWithResponseAsync(String modelId, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return FluxUtil.withContext(context -> this.service.analyzeDocument(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", "application/json", requestOptionsLocal, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> analyzeDocumentWithResponse(String modelId, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        RequestOptions requestOptionsLocal = requestOptions == null ? new RequestOptions() : requestOptions;
        requestOptionsLocal.addRequestCallback(requestLocal -> {
            if (requestLocal.getBody() != null && requestLocal.getHeaders().get(HttpHeaderName.CONTENT_TYPE) == null) {
                requestLocal.getHeaders().set(HttpHeaderName.CONTENT_TYPE, "application/json");
            }
        });
        return this.service.analyzeDocumentSync(this.getEndpoint(), this.getServiceVersion().getVersion(), modelId, "application/json", "application/json", requestOptionsLocal, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginAnalyzeDocumentAsync(String modelId, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginAnalyzeDocument(String modelId, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResultOperation> beginAnalyzeDocumentWithModelAsync(String modelId, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponseAsync(modelId, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeResultOperation, AnalyzeResultOperation> beginAnalyzeDocumentWithModel(String modelId, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.analyzeDocumentWithResponse(modelId, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> classifyDocumentWithResponseAsync(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.classifyDocument(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", "application/json", classifyRequest, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<Void> classifyDocumentWithResponse(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.classifyDocumentSync(this.getEndpoint(), this.getServiceVersion().getVersion(), classifierId, "application/json", "application/json", classifyRequest, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginClassifyDocumentAsync(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, classifyRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginClassifyDocument(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, classifyRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<AnalyzeResultOperation, AnalyzeResultOperation> beginClassifyDocumentWithModelAsync(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponseAsync(classifierId, classifyRequest, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<AnalyzeResultOperation, AnalyzeResultOperation> beginClassifyDocumentWithModel(String classifierId, BinaryData classifyRequest, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.classifyDocumentWithResponse(classifierId, classifyRequest, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}/documentintelligence".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class), (TypeReference)TypeReference.createInstance(AnalyzeResultOperation.class));
    }

    @Host(value="{endpoint}/documentintelligence")
    @ServiceInterface(name="DocumentIntelligence")
    public static interface DocumentIntelligenceClientService {
        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> analyzeDocument(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/documentModels/{modelId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> analyzeDocumentSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="modelId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, RequestOptions var6, Context var7);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> classifyDocument(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);

        @Post(value="/documentClassifiers/{classifierId}:analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> classifyDocumentSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="classifierId") String var3, @HeaderParam(value="content-type") String var4, @HeaderParam(value="accept") String var5, @BodyParam(value="application/json") BinaryData var6, RequestOptions var7, Context var8);
    }
}

