/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.append;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.append.JsonDeserializer;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.Test;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class RawEntityConverter {
    private final ExtentReports extent;

    public RawEntityConverter(ExtentReports extent) {
        this.extent = extent;
    }

    public void convertAndApply(File jsonFile) throws IOException {
        if (!jsonFile.exists()) {
            return;
        }
        this.extent.setReportUsesManualConfiguration(true);
        List<Test> tests = new JsonDeserializer(jsonFile).deserialize();
        for (Test test : tests) {
            try {
                ExtentTest extentTest;
                if (test.isBDD()) {
                    GherkinKeyword gk = new GherkinKeyword(test.getBddType().getSimpleName());
                    extentTest = this.extent.createTest(gk, test.getName(), test.getDescription());
                } else {
                    extentTest = this.extent.createTest(test.getName(), test.getDescription());
                }
                this.createDomain(test, extentTest);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void createDomain(Test test, ExtentTest extentTest) throws ClassNotFoundException {
        extentTest.getModel().setStartTime(test.getStartTime());
        extentTest.getModel().setEndTime(test.getEndTime());
        this.constructTestMedia(test, extentTest);
        for (Log log : test.getLogs()) {
            if (log.hasException() || log.hasMedia()) {
                this.constructLog(log, extentTest, log.getException());
                continue;
            }
            extentTest.log(log.getStatus(), log.getDetails());
        }
        test.getAuthorSet().stream().map(NamedAttribute::getName).forEach(xva$0 -> extentTest.assignAuthor((String)xva$0));
        test.getCategorySet().stream().map(NamedAttribute::getName).forEach(xva$0 -> extentTest.assignCategory((String)xva$0));
        test.getDeviceSet().stream().map(NamedAttribute::getName).forEach(xva$0 -> extentTest.assignDevice((String)xva$0));
        for (Test node : test.getChildren()) {
            ExtentTest extentNode;
            if (!node.isBDD()) {
                extentNode = extentTest.createNode(node.getName(), node.getDescription());
            } else {
                GherkinKeyword gk = new GherkinKeyword(node.getBddType().getSimpleName());
                extentNode = extentTest.createNode(gk, node.getName(), node.getDescription());
            }
            this.constructTestMedia(node, extentNode);
            this.createDomain(node, extentNode);
        }
    }

    private void constructLog(Log log, ExtentTest extentTest, ExceptionInfo ex) {
        Media m = log.getMedia();
        extentTest.log(log.getStatus(), log.getDetails(), m);
        if (ex != null) {
            List<Log> logs = extentTest.getModel().getLogs();
            Log lastLog = logs.get(logs.size() - 1);
            lastLog.setException(ex);
            extentTest.getModel().getExceptions().add(ex);
        }
    }

    private void constructTestMedia(Test test, ExtentTest extentTest) {
        if (test.getMedia() != null) {
            for (Media m : test.getMedia()) {
                extentTest.addMedia(m);
            }
        }
    }
}

