/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.testng.listener;

import com.aventstack.extentreports.AnalysisStrategy;
import com.aventstack.extentreports.service.ExtentService;
import com.aventstack.extentreports.service.ExtentTestManager;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class ExtentITestListenerAdapter
implements ITestListener,
IInvokedMethodListener {
    private Boolean createdMethodBeforeInvocation = false;

    public synchronized void onStart(ITestContext context) {
        ExtentService.getInstance().setAnalysisStrategy(AnalysisStrategy.TEST);
    }

    public synchronized void onFinish(ITestContext context) {
        ExtentService.getInstance().flush();
    }

    public synchronized void onTestStart(ITestResult result) {
        if (!this.createdMethodBeforeInvocation.booleanValue()) {
            ExtentTestManager.createMethod(result);
        }
    }

    public synchronized void onTestSuccess(ITestResult result) {
        ExtentTestManager.log(result);
    }

    public synchronized void onTestFailure(ITestResult result) {
        ExtentTestManager.log(result);
    }

    public synchronized void onTestSkipped(ITestResult result) {
        if (result.wasRetried()) {
            ExtentService.getInstance().removeTest(result.getName());
        } else {
            ExtentTestManager.log(result);
        }
    }

    public synchronized void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method.getTestMethod().isBeforeMethodConfiguration()) {
            this.createdMethodBeforeInvocation = true;
            ExtentTestManager.createMethod(testResult);
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }
}

