/*
 * ACI Services API
 * API for methods pertaining to all ACI services
 *
 * OpenAPI spec version: 3.0.2
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;

/**
 * Please note that ownership activity is a separately licensed section of the vehicle history responses. Please contact your Red Mountain sales team if you wish to receive ownership activity information
 */
@ApiModel(description = "Please note that ownership activity is a separately licensed section of the vehicle history responses. Please contact your Red Mountain sales team if you wish to receive ownership activity information")

public class VehicleOwnershipActivity {
  @SerializedName("accidentEvent")
  private Boolean accidentEvent = null;

  @SerializedName("duration")
  private String duration = null;

  @SerializedName("end")
  private LocalDate end = null;

  @SerializedName("sequenceNumber")
  private Integer sequenceNumber = null;

  @SerializedName("start")
  private LocalDate start = null;

  @SerializedName("state")
  private String state = null;

  @SerializedName("yearPurchased")
  private Integer yearPurchased = null;

  public VehicleOwnershipActivity accidentEvent(Boolean accidentEvent) {
    this.accidentEvent = accidentEvent;
    return this;
  }

   /**
   * indicates if this owner had any accident related activity with this vehicle
   * @return accidentEvent
  **/
  @ApiModelProperty(value = "indicates if this owner had any accident related activity with this vehicle")
  public Boolean isAccidentEvent() {
    return accidentEvent;
  }

  public void setAccidentEvent(Boolean accidentEvent) {
    this.accidentEvent = accidentEvent;
  }

  public VehicleOwnershipActivity duration(String duration) {
    this.duration = duration;
    return this;
  }

   /**
   * the duration of ownership
   * @return duration
  **/
  @ApiModelProperty(value = "the duration of ownership")
  public String getDuration() {
    return duration;
  }

  public void setDuration(String duration) {
    this.duration = duration;
  }

  public VehicleOwnershipActivity end(LocalDate end) {
    this.end = end;
    return this;
  }

   /**
   * the date ownership ended
   * @return end
  **/
  @ApiModelProperty(value = "the date ownership ended")
  public LocalDate getEnd() {
    return end;
  }

  public void setEnd(LocalDate end) {
    this.end = end;
  }

  public VehicleOwnershipActivity sequenceNumber(Integer sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
    return this;
  }

   /**
   * the sequence number
   * @return sequenceNumber
  **/
  @ApiModelProperty(value = "the sequence number")
  public Integer getSequenceNumber() {
    return sequenceNumber;
  }

  public void setSequenceNumber(Integer sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
  }

  public VehicleOwnershipActivity start(LocalDate start) {
    this.start = start;
    return this;
  }

   /**
   * the date ownership started
   * @return start
  **/
  @ApiModelProperty(value = "the date ownership started")
  public LocalDate getStart() {
    return start;
  }

  public void setStart(LocalDate start) {
    this.start = start;
  }

  public VehicleOwnershipActivity state(String state) {
    this.state = state;
    return this;
  }

   /**
   * the state in which the ownership occurred
   * @return state
  **/
  @ApiModelProperty(value = "the state in which the ownership occurred")
  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public VehicleOwnershipActivity yearPurchased(Integer yearPurchased) {
    this.yearPurchased = yearPurchased;
    return this;
  }

   /**
   * the year this owner purchased the vehicle
   * @return yearPurchased
  **/
  @ApiModelProperty(value = "the year this owner purchased the vehicle")
  public Integer getYearPurchased() {
    return yearPurchased;
  }

  public void setYearPurchased(Integer yearPurchased) {
    this.yearPurchased = yearPurchased;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VehicleOwnershipActivity vehicleOwnershipActivity = (VehicleOwnershipActivity) o;
    return Objects.equals(this.accidentEvent, vehicleOwnershipActivity.accidentEvent) &&
        Objects.equals(this.duration, vehicleOwnershipActivity.duration) &&
        Objects.equals(this.end, vehicleOwnershipActivity.end) &&
        Objects.equals(this.sequenceNumber, vehicleOwnershipActivity.sequenceNumber) &&
        Objects.equals(this.start, vehicleOwnershipActivity.start) &&
        Objects.equals(this.state, vehicleOwnershipActivity.state) &&
        Objects.equals(this.yearPurchased, vehicleOwnershipActivity.yearPurchased);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accidentEvent, duration, end, sequenceNumber, start, state, yearPurchased);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VehicleOwnershipActivity {\n");
    
    sb.append("    accidentEvent: ").append(toIndentedString(accidentEvent)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("    sequenceNumber: ").append(toIndentedString(sequenceNumber)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    yearPurchased: ").append(toIndentedString(yearPurchased)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

