/*
 * ACI Services API
 * API for methods pertaining to all ACI services
 *
 * OpenAPI spec version: 3.0.2
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.model;

import java.util.Objects;
import java.util.Arrays;
import com.autocheckinsurance.sdk.model.VehicleRiskRequestAttribute;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * RiskCalculationRequest
 */

public class RiskCalculationRequest {
  /**
   * the risk prediction type
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    DEFAULT("Default"),
    
    CA("CA"),
    
    FL("FL"),
    
    SC("SC"),
    
    NM("NM"),
    
    AZ("AZ");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("vehicleRiskRequestAttributes")
  private java.util.List<VehicleRiskRequestAttribute> vehicleRiskRequestAttributes = new java.util.ArrayList<>();

  public RiskCalculationRequest type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * the risk prediction type
   * @return type
  **/
  @ApiModelProperty(value = "the risk prediction type")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public RiskCalculationRequest vehicleRiskRequestAttributes(java.util.List<VehicleRiskRequestAttribute> vehicleRiskRequestAttributes) {
    this.vehicleRiskRequestAttributes = vehicleRiskRequestAttributes;
    return this;
  }

  public RiskCalculationRequest addVehicleRiskRequestAttributesItem(VehicleRiskRequestAttribute vehicleRiskRequestAttributesItem) {
    this.vehicleRiskRequestAttributes.add(vehicleRiskRequestAttributesItem);
    return this;
  }

   /**
   * the list of vehicle identification numbers/effective end date combinations
   * @return vehicleRiskRequestAttributes
  **/
  @ApiModelProperty(required = true, value = "the list of vehicle identification numbers/effective end date combinations")
  public java.util.List<VehicleRiskRequestAttribute> getVehicleRiskRequestAttributes() {
    return vehicleRiskRequestAttributes;
  }

  public void setVehicleRiskRequestAttributes(java.util.List<VehicleRiskRequestAttribute> vehicleRiskRequestAttributes) {
    this.vehicleRiskRequestAttributes = vehicleRiskRequestAttributes;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RiskCalculationRequest riskCalculationRequest = (RiskCalculationRequest) o;
    return Objects.equals(this.type, riskCalculationRequest.type) &&
        Objects.equals(this.vehicleRiskRequestAttributes, riskCalculationRequest.vehicleRiskRequestAttributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, vehicleRiskRequestAttributes);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskCalculationRequest {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vehicleRiskRequestAttributes: ").append(toIndentedString(vehicleRiskRequestAttributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

