/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="historical activity for the vehicle")
public class HistoryRecord {
    @SerializedName(value="accidentSequenceNumber")
    private String accidentSequenceNumber = null;
    @SerializedName(value="activityCode")
    private Integer activityCode = null;
    @SerializedName(value="caseNumber")
    private String caseNumber = null;
    @SerializedName(value="category")
    private String category = null;
    @SerializedName(value="checklistGroup")
    private Integer checklistGroup = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="date")
    private LocalDate date = null;
    @SerializedName(value="lease")
    private Boolean lease = null;
    @SerializedName(value="lien")
    private Boolean lien = null;
    @SerializedName(value="odometer")
    private Integer odometer = null;
    @SerializedName(value="orgName")
    private String orgName = null;
    @SerializedName(value="originalIncidentReportedDate")
    private LocalDate originalIncidentReportedDate = null;
    @SerializedName(value="oru")
    private OruEnum oru = null;
    @SerializedName(value="phone")
    private String phone = null;
    @SerializedName(value="recallCode")
    private String recallCode = null;
    @SerializedName(value="recallLinkTxt")
    private String recallLinkTxt = null;
    @SerializedName(value="recallTxt")
    private String recallTxt = null;
    @SerializedName(value="recallUrl")
    private String recallUrl = null;
    @SerializedName(value="rollback")
    private Boolean rollback = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="titleRegStorm")
    private Boolean titleRegStorm = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="uom")
    private UomEnum uom = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="urlLink")
    private Boolean urlLink = null;

    public HistoryRecord accidentSequenceNumber(String accidentSequenceNumber) {
        this.accidentSequenceNumber = accidentSequenceNumber;
        return this;
    }

    @ApiModelProperty(value="the accident sequence number")
    public String getAccidentSequenceNumber() {
        return this.accidentSequenceNumber;
    }

    public void setAccidentSequenceNumber(String accidentSequenceNumber) {
        this.accidentSequenceNumber = accidentSequenceNumber;
    }

    public HistoryRecord activityCode(Integer activityCode) {
        this.activityCode = activityCode;
        return this;
    }

    @ApiModelProperty(value="the unique identifier for the activity type")
    public Integer getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(Integer activityCode) {
        this.activityCode = activityCode;
    }

    public HistoryRecord caseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
        return this;
    }

    @ApiModelProperty(value="the case number")
    public String getCaseNumber() {
        return this.caseNumber;
    }

    public void setCaseNumber(String caseNumber) {
        this.caseNumber = caseNumber;
    }

    public HistoryRecord category(String category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="the activity category")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public HistoryRecord checklistGroup(Integer checklistGroup) {
        this.checklistGroup = checklistGroup;
        return this;
    }

    @ApiModelProperty(value="the checklist group")
    public Integer getChecklistGroup() {
        return this.checklistGroup;
    }

    public void setChecklistGroup(Integer checklistGroup) {
        this.checklistGroup = checklistGroup;
    }

    public HistoryRecord city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="the city in which the activity was reported")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public HistoryRecord color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(value="the color of a vehicle supplied by dealer")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public HistoryRecord date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="the date of the activity")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public HistoryRecord lease(Boolean lease) {
        this.lease = lease;
        return this;
    }

    @ApiModelProperty(value="indicates if this is a lease record")
    public Boolean isLease() {
        return this.lease;
    }

    public void setLease(Boolean lease) {
        this.lease = lease;
    }

    public HistoryRecord lien(Boolean lien) {
        this.lien = lien;
        return this;
    }

    @ApiModelProperty(value="indicates if this is a lein record")
    public Boolean isLien() {
        return this.lien;
    }

    public void setLien(Boolean lien) {
        this.lien = lien;
    }

    public HistoryRecord odometer(Integer odometer) {
        this.odometer = odometer;
        return this;
    }

    @ApiModelProperty(value="the odometer reading")
    public Integer getOdometer() {
        return this.odometer;
    }

    public void setOdometer(Integer odometer) {
        this.odometer = odometer;
    }

    public HistoryRecord orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @ApiModelProperty(value="the name of the reporting organization")
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public HistoryRecord originalIncidentReportedDate(LocalDate originalIncidentReportedDate) {
        this.originalIncidentReportedDate = originalIncidentReportedDate;
        return this;
    }

    @ApiModelProperty(value="the date of the incident was reported")
    public LocalDate getOriginalIncidentReportedDate() {
        return this.originalIncidentReportedDate;
    }

    public void setOriginalIncidentReportedDate(LocalDate originalIncidentReportedDate) {
        this.originalIncidentReportedDate = originalIncidentReportedDate;
    }

    public HistoryRecord oru(OruEnum oru) {
        this.oru = oru;
        return this;
    }

    @ApiModelProperty(value="odometer rollback use indicator of how odometer reading is used in rollback calculation")
    public OruEnum getOru() {
        return this.oru;
    }

    public void setOru(OruEnum oru) {
        this.oru = oru;
    }

    public HistoryRecord phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="the phone of the reporting organization")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public HistoryRecord recallCode(String recallCode) {
        this.recallCode = recallCode;
        return this;
    }

    @ApiModelProperty(value="recall code supplied by manufacturer")
    public String getRecallCode() {
        return this.recallCode;
    }

    public void setRecallCode(String recallCode) {
        this.recallCode = recallCode;
    }

    public HistoryRecord recallLinkTxt(String recallLinkTxt) {
        this.recallLinkTxt = recallLinkTxt;
        return this;
    }

    @ApiModelProperty(value="used in URL text")
    public String getRecallLinkTxt() {
        return this.recallLinkTxt;
    }

    public void setRecallLinkTxt(String recallLinkTxt) {
        this.recallLinkTxt = recallLinkTxt;
    }

    public HistoryRecord recallTxt(String recallTxt) {
        this.recallTxt = recallTxt;
        return this;
    }

    @ApiModelProperty(value="description of recall")
    public String getRecallTxt() {
        return this.recallTxt;
    }

    public void setRecallTxt(String recallTxt) {
        this.recallTxt = recallTxt;
    }

    public HistoryRecord recallUrl(String recallUrl) {
        this.recallUrl = recallUrl;
        return this;
    }

    @ApiModelProperty(value="the URL is supplied by the manufacturer")
    public String getRecallUrl() {
        return this.recallUrl;
    }

    public void setRecallUrl(String recallUrl) {
        this.recallUrl = recallUrl;
    }

    public HistoryRecord rollback(Boolean rollback) {
        this.rollback = rollback;
        return this;
    }

    @ApiModelProperty(value="indicates if this is a rollback record")
    public Boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(Boolean rollback) {
        this.rollback = rollback;
    }

    public HistoryRecord state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="the state in which the activity occurred")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public HistoryRecord title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="the title record")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public HistoryRecord titleRegStorm(Boolean titleRegStorm) {
        this.titleRegStorm = titleRegStorm;
        return this;
    }

    @ApiModelProperty(value="indicates there has been a title or registration event in a major storm area sometime prior to the storm")
    public Boolean isTitleRegStorm() {
        return this.titleRegStorm;
    }

    public void setTitleRegStorm(Boolean titleRegStorm) {
        this.titleRegStorm = titleRegStorm;
    }

    public HistoryRecord type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="the type of activity")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public HistoryRecord uom(UomEnum uom) {
        this.uom = uom;
        return this;
    }

    @ApiModelProperty(value="the odometer unit of measurement")
    public UomEnum getUom() {
        return this.uom;
    }

    public void setUom(UomEnum uom) {
        this.uom = uom;
    }

    public HistoryRecord url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="the URL supplied by a dealer")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HistoryRecord urlLink(Boolean urlLink) {
        this.urlLink = urlLink;
        return this;
    }

    @ApiModelProperty(value="indicates whether or not the url needs to display as a hyperlink in the history section of the report")
    public Boolean isUrlLink() {
        return this.urlLink;
    }

    public void setUrlLink(Boolean urlLink) {
        this.urlLink = urlLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryRecord historyRecord = (HistoryRecord)o;
        return Objects.equals(this.accidentSequenceNumber, historyRecord.accidentSequenceNumber) && Objects.equals(this.activityCode, historyRecord.activityCode) && Objects.equals(this.caseNumber, historyRecord.caseNumber) && Objects.equals(this.category, historyRecord.category) && Objects.equals(this.checklistGroup, historyRecord.checklistGroup) && Objects.equals(this.city, historyRecord.city) && Objects.equals(this.color, historyRecord.color) && Objects.equals(this.date, historyRecord.date) && Objects.equals(this.lease, historyRecord.lease) && Objects.equals(this.lien, historyRecord.lien) && Objects.equals(this.odometer, historyRecord.odometer) && Objects.equals(this.orgName, historyRecord.orgName) && Objects.equals(this.originalIncidentReportedDate, historyRecord.originalIncidentReportedDate) && Objects.equals((Object)this.oru, (Object)historyRecord.oru) && Objects.equals(this.phone, historyRecord.phone) && Objects.equals(this.recallCode, historyRecord.recallCode) && Objects.equals(this.recallLinkTxt, historyRecord.recallLinkTxt) && Objects.equals(this.recallTxt, historyRecord.recallTxt) && Objects.equals(this.recallUrl, historyRecord.recallUrl) && Objects.equals(this.rollback, historyRecord.rollback) && Objects.equals(this.state, historyRecord.state) && Objects.equals(this.title, historyRecord.title) && Objects.equals(this.titleRegStorm, historyRecord.titleRegStorm) && Objects.equals(this.type, historyRecord.type) && Objects.equals((Object)this.uom, (Object)historyRecord.uom) && Objects.equals(this.url, historyRecord.url) && Objects.equals(this.urlLink, historyRecord.urlLink);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accidentSequenceNumber, this.activityCode, this.caseNumber, this.category, this.checklistGroup, this.city, this.color, this.date, this.lease, this.lien, this.odometer, this.orgName, this.originalIncidentReportedDate, this.oru, this.phone, this.recallCode, this.recallLinkTxt, this.recallTxt, this.recallUrl, this.rollback, this.state, this.title, this.titleRegStorm, this.type, this.uom, this.url, this.urlLink});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryRecord {\n");
        sb.append("    accidentSequenceNumber: ").append(this.toIndentedString(this.accidentSequenceNumber)).append("\n");
        sb.append("    activityCode: ").append(this.toIndentedString(this.activityCode)).append("\n");
        sb.append("    caseNumber: ").append(this.toIndentedString(this.caseNumber)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    checklistGroup: ").append(this.toIndentedString(this.checklistGroup)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    lease: ").append(this.toIndentedString(this.lease)).append("\n");
        sb.append("    lien: ").append(this.toIndentedString(this.lien)).append("\n");
        sb.append("    odometer: ").append(this.toIndentedString(this.odometer)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    originalIncidentReportedDate: ").append(this.toIndentedString(this.originalIncidentReportedDate)).append("\n");
        sb.append("    oru: ").append(this.toIndentedString((Object)this.oru)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    recallCode: ").append(this.toIndentedString(this.recallCode)).append("\n");
        sb.append("    recallLinkTxt: ").append(this.toIndentedString(this.recallLinkTxt)).append("\n");
        sb.append("    recallTxt: ").append(this.toIndentedString(this.recallTxt)).append("\n");
        sb.append("    recallUrl: ").append(this.toIndentedString(this.recallUrl)).append("\n");
        sb.append("    rollback: ").append(this.toIndentedString(this.rollback)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleRegStorm: ").append(this.toIndentedString(this.titleRegStorm)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    uom: ").append(this.toIndentedString((Object)this.uom)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    urlLink: ").append(this.toIndentedString(this.urlLink)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UomEnum {
        M("M"),
        K("K"),
        U("U");

        private String value;

        private UomEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UomEnum fromValue(String text) {
            for (UomEnum b : UomEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UomEnum> {
            public void write(JsonWriter jsonWriter, UomEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UomEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UomEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OruEnum {
        H("H"),
        N("N"),
        R("R");

        private String value;

        private OruEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OruEnum fromValue(String text) {
            for (OruEnum b : OruEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OruEnum> {
            public void write(JsonWriter jsonWriter, OruEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OruEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OruEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

