/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.api;

import com.autocheckinsurance.sdk.ApiClient;
import com.autocheckinsurance.sdk.ApiException;
import com.autocheckinsurance.sdk.api.VehicleApi;
import com.autocheckinsurance.sdk.api.VehicleHistoryApi;
import com.autocheckinsurance.sdk.model.HistoryRequest;
import com.autocheckinsurance.sdk.model.HistoryResponse;
import com.autocheckinsurance.sdk.model.RiskCalculationRequest;
import com.autocheckinsurance.sdk.model.RiskCalculationResponse;
import com.autocheckinsurance.sdk.model.Vehicle;
import com.autocheckinsurance.sdk.model.VehicleRequestAttribute;
import com.autocheckinsurance.sdk.model.VehicleRiskRequestAttribute;
import com.autocheckinsurance.sdk.model.VehicleRiskResult;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HandwrittenTest {
    private static List<String> vinList = null;

    @Test
    public void singleCalcRiskTest() throws ApiException, IOException {
        int count = 0;
        for (String vin : HandwrittenTest.getVins()) {
            if (count >= 5) continue;
            RiskCalculationRequest request = new RiskCalculationRequest();
            request.setType(RiskCalculationRequest.TypeEnum.FL);
            request.addVehicleRiskRequestAttributesItem(this.createRiskAttribute(vin));
            RiskCalculationResponse response = this.getVehicleApi().calcRisk("aHENhkHf8RdJDz1znk0c2hLbkDH3EBw13hiix787", "ACDV0036", request);
            Assert.assertEquals((long)request.getVehicleRiskRequestAttributes().size(), (long)response.getVehicleRiskResults().size());
            this.verifyRiskResponses(request.getVehicleRiskRequestAttributes(), response.getVehicleRiskResults());
            ++count;
        }
    }

    @Test
    public void multiCalcRiskTest() throws ApiException, IOException {
        RiskCalculationRequest request = new RiskCalculationRequest();
        request.setType(RiskCalculationRequest.TypeEnum.DEFAULT);
        int count = 0;
        for (String vin : HandwrittenTest.getVins()) {
            if (count >= 2) continue;
            request.addVehicleRiskRequestAttributesItem(this.createRiskAttribute(vin));
            ++count;
        }
        RiskCalculationResponse response = this.getVehicleApi().calcRisk("aHENhkHf8RdJDz1znk0c2hLbkDH3EBw13hiix787", "ACDV0036", request);
        Assert.assertEquals((Object)RiskCalculationResponse.TypeEnum.DEFAULT, (Object)response.getType());
        Assert.assertEquals((long)request.getVehicleRiskRequestAttributes().size(), (long)response.getVehicleRiskResults().size());
        this.verifyRiskResponses(request.getVehicleRiskRequestAttributes(), response.getVehicleRiskResults());
    }

    @Test
    public void singleHistoryTest() throws ApiException, IOException {
        int count = 0;
        for (String vin : HandwrittenTest.getVins()) {
            if (count >= 5) continue;
            HistoryRequest request = new HistoryRequest();
            request.addVehicleRequestAttributesItem(this.createHistoryAttribute(vin));
            HistoryResponse response = this.getVehicleHistoryApi().historyFull("aHENhkHf8RdJDz1znk0c2hLbkDH3EBw13hiix787", "ACDV0036", request);
            Assert.assertEquals((long)request.getVehicleRequestAttributes().size(), (long)response.getCount().intValue());
            this.verifyHistoryResponses(request.getVehicleRequestAttributes(), response.getVehicles());
            ++count;
        }
    }

    @Test
    public void multiHistoryTest() throws ApiException, IOException {
        HistoryRequest request = new HistoryRequest();
        int count = 0;
        for (String vin : HandwrittenTest.getVins()) {
            if (count >= 5) continue;
            request.addVehicleRequestAttributesItem(this.createHistoryAttribute(vin));
            ++count;
        }
        HistoryResponse response = this.getVehicleHistoryApi().historyFull("aHENhkHf8RdJDz1znk0c2hLbkDH3EBw13hiix787", "ACDV0036", request);
        Assert.assertEquals((long)request.getVehicleRequestAttributes().size(), (long)response.getCount().intValue());
        this.verifyHistoryResponses(request.getVehicleRequestAttributes(), response.getVehicles());
    }

    private VehicleRequestAttribute createHistoryAttribute(String vin) {
        VehicleRequestAttribute attr = new VehicleRequestAttribute();
        attr.setReferenceNumber("ref-" + vin);
        attr.setVin(vin);
        return attr;
    }

    private void verifyHistoryResponses(List<VehicleRequestAttribute> request, List<Vehicle> response) {
        HashMap<String, VehicleRequestAttribute> attrs = new HashMap<String, VehicleRequestAttribute>();
        for (VehicleRequestAttribute attr : request) {
            attrs.put(attr.getVin(), attr);
        }
        for (Vehicle result : response) {
            this.verifyHistoryResponse((VehicleRequestAttribute)attrs.get(result.getVehicleInformation().getVin()), result);
        }
    }

    private void verifyHistoryResponse(VehicleRequestAttribute req, Vehicle res) {
        Assert.assertEquals((Object)req.getReferenceNumber(), (Object)res.getReferenceNumber());
        Assert.assertNotNull((Object)res.getHistory());
        Assert.assertNotNull((Object)res.getVehicleInformation());
    }

    private void verifyRiskResponses(List<VehicleRiskRequestAttribute> request, List<VehicleRiskResult> response) {
        HashMap<String, VehicleRiskRequestAttribute> attrs = new HashMap<String, VehicleRiskRequestAttribute>();
        for (VehicleRiskRequestAttribute attr : request) {
            attrs.put(attr.getVin(), attr);
        }
        for (VehicleRiskResult result : response) {
            this.verifyRiskResponse((VehicleRiskRequestAttribute)attrs.get(result.getVin()), result);
        }
    }

    private void verifyRiskResponse(VehicleRiskRequestAttribute req, VehicleRiskResult res) {
        try {
            Integer.parseInt(res.getResults());
            Assert.assertEquals((Object)req.getEffectiveEndDate(), (Object)res.getEffectiveEndDate());
            Assert.assertEquals((Object)req.getReferenceNumber(), (Object)res.getReferenceNumber());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals((Object)req.getVin(), (Object)res.getVin());
        Assert.assertNotNull((Object)res.getResults());
    }

    private VehicleRiskRequestAttribute createRiskAttribute(String vin) {
        VehicleRiskRequestAttribute attr = new VehicleRiskRequestAttribute();
        attr.setEffectiveEndDate(LocalDate.now());
        attr.setReferenceNumber("ref-" + vin);
        attr.setVin(vin);
        return attr;
    }

    private VehicleApi getVehicleApi() {
        ApiClient client = new ApiClient();
        client.setApiKey("Thisisa20charkeyplus");
        client.setBasePath("https://api.dev.autotec.com/latest");
        return new VehicleApi(client);
    }

    private VehicleHistoryApi getVehicleHistoryApi() {
        ApiClient client = new ApiClient();
        client.setApiKey("Thisisa20charkeyplus");
        client.setBasePath("https://api.dev.autotec.com/latest");
        return new VehicleHistoryApi(client);
    }

    private static List<String> getVins() throws IOException {
        if (vinList == null) {
            ArrayList<String> vins = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader("keep/vins.txt"));){
                String vin;
                while ((vin = reader.readLine()) != null) {
                    if ((vin = vin.trim()).isEmpty()) continue;
                    vins.add(vin);
                }
                vinList = vins;
            }
        }
        return vinList;
    }
}

