/*
 * ACI Services API
 * API for methods pertaining to all ACI services
 *
 * OpenAPI spec version: 2.0.2
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.api;

import com.autocheckinsurance.sdk.ApiCallback;
import com.autocheckinsurance.sdk.ApiClient;
import com.autocheckinsurance.sdk.ApiException;
import com.autocheckinsurance.sdk.ApiResponse;
import com.autocheckinsurance.sdk.Configuration;
import com.autocheckinsurance.sdk.Pair;
import com.autocheckinsurance.sdk.ProgressRequestBody;
import com.autocheckinsurance.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.autocheckinsurance.sdk.model.RiskCalculationPlusResponse;
import com.autocheckinsurance.sdk.model.RiskCalculationRequest;
import com.autocheckinsurance.sdk.model.RiskCalculationResponse;

import java.lang.reflect.Type;

public class VehicleApi {
    private ApiClient apiClient;

    public VehicleApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VehicleApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for calcRisk
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The calculation request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call calcRiskCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/vehicle/risk";

        java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
        java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();

        java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
        if (xApiKey != null)
        localVarHeaderParams.put("x-api-key", apiClient.parameterToString(xApiKey));
        if (xAutotecId != null)
        localVarHeaderParams.put("x-autotec-id", apiClient.parameterToString(xAutotecId));

        java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "CustomerAuthorizer", "api_key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call calcRiskValidateBeforeCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'xApiKey' is set
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling calcRisk(Async)");
        }
        
        // verify the required parameter 'xAutotecId' is set
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling calcRisk(Async)");
        }
        
        // verify the required parameter 'request' is set
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling calcRisk(Async)");
        }
        

        com.squareup.okhttp.Call call = calcRiskCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Calculate Risk of Loss for Requested Vehicles
     * Method for calculating Loss Risk Prediction for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The calculation request (required)
     * @return RiskCalculationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RiskCalculationResponse calcRisk(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        ApiResponse<RiskCalculationResponse> resp = calcRiskWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    /**
     * Calculate Risk of Loss for Requested Vehicles
     * Method for calculating Loss Risk Prediction for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The calculation request (required)
     * @return ApiResponse&lt;RiskCalculationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RiskCalculationResponse> calcRiskWithHttpInfo(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        com.squareup.okhttp.Call call = calcRiskValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<RiskCalculationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Calculate Risk of Loss for Requested Vehicles (asynchronously)
     * Method for calculating Loss Risk Prediction for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The calculation request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call calcRiskAsync(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ApiCallback<RiskCalculationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = calcRiskValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskCalculationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for calcRiskPlus
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call calcRiskPlusCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/vehicle/risk/plus";

        java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
        java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();

        java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
        if (xApiKey != null)
        localVarHeaderParams.put("x-api-key", apiClient.parameterToString(xApiKey));
        if (xAutotecId != null)
        localVarHeaderParams.put("x-autotec-id", apiClient.parameterToString(xAutotecId));

        java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "CustomerAuthorizer", "api_key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call calcRiskPlusValidateBeforeCall(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'xApiKey' is set
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling calcRiskPlus(Async)");
        }
        
        // verify the required parameter 'xAutotecId' is set
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling calcRiskPlus(Async)");
        }
        
        // verify the required parameter 'request' is set
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling calcRiskPlus(Async)");
        }
        

        com.squareup.okhttp.Call call = calcRiskPlusCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Calculate Risk of Loss and return Full History for Requested Vehicles
     * Method for calculating Loss Risk Prediction and returning Full History for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The request (required)
     * @return RiskCalculationPlusResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public RiskCalculationPlusResponse calcRiskPlus(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        ApiResponse<RiskCalculationPlusResponse> resp = calcRiskPlusWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    /**
     * Calculate Risk of Loss and return Full History for Requested Vehicles
     * Method for calculating Loss Risk Prediction and returning Full History for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The request (required)
     * @return ApiResponse&lt;RiskCalculationPlusResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<RiskCalculationPlusResponse> calcRiskPlusWithHttpInfo(String xApiKey, String xAutotecId, RiskCalculationRequest request) throws ApiException {
        com.squareup.okhttp.Call call = calcRiskPlusValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<RiskCalculationPlusResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Calculate Risk of Loss and return Full History for Requested Vehicles (asynchronously)
     * Method for calculating Loss Risk Prediction and returning Full History for a list of vehicles. The different types of Loss Risk Prediction varies in the algorithm multipliers and the history activity to utilize for each categorization of historical activity.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call calcRiskPlusAsync(String xApiKey, String xAutotecId, RiskCalculationRequest request, final ApiCallback<RiskCalculationPlusResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = calcRiskPlusValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RiskCalculationPlusResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
