/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.model;

import com.autocheckinsurance.sdk.model.VehicleHistory;
import com.autocheckinsurance.sdk.model.VehicleInformation;
import com.autocheckinsurance.sdk.model.VehicleOwnershipActivity;
import com.autocheckinsurance.sdk.model.VehicleRecall;
import com.autocheckinsurance.sdk.model.VehicleScoring;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The vehicle and it's requested data.  NOTE: Data elements returned are dependent on the request.")
public class Vehicle {
    @SerializedName(value="history")
    private VehicleHistory history = null;
    @SerializedName(value="recalls")
    private VehicleRecall recalls = null;
    @SerializedName(value="referenceNumber")
    private String referenceNumber = null;
    @SerializedName(value="scoring")
    private VehicleScoring scoring = null;
    @SerializedName(value="vehicleInformation")
    private VehicleInformation vehicleInformation = null;
    @SerializedName(value="vehicleOwnerHistory")
    private List<VehicleOwnershipActivity> vehicleOwnerHistory = null;

    public Vehicle history(VehicleHistory history) {
        this.history = history;
        return this;
    }

    @ApiModelProperty(value="")
    public VehicleHistory getHistory() {
        return this.history;
    }

    public void setHistory(VehicleHistory history) {
        this.history = history;
    }

    public Vehicle recalls(VehicleRecall recalls) {
        this.recalls = recalls;
        return this;
    }

    @ApiModelProperty(value="recall information for the vehicle")
    public VehicleRecall getRecalls() {
        return this.recalls;
    }

    public void setRecalls(VehicleRecall recalls) {
        this.recalls = recalls;
    }

    public Vehicle referenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
        return this;
    }

    @ApiModelProperty(value="the reference number for the caller's tracking purposes")
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public Vehicle scoring(VehicleScoring scoring) {
        this.scoring = scoring;
        return this;
    }

    @ApiModelProperty(value="")
    public VehicleScoring getScoring() {
        return this.scoring;
    }

    public void setScoring(VehicleScoring scoring) {
        this.scoring = scoring;
    }

    public Vehicle vehicleInformation(VehicleInformation vehicleInformation) {
        this.vehicleInformation = vehicleInformation;
        return this;
    }

    @ApiModelProperty(value="")
    public VehicleInformation getVehicleInformation() {
        return this.vehicleInformation;
    }

    public void setVehicleInformation(VehicleInformation vehicleInformation) {
        this.vehicleInformation = vehicleInformation;
    }

    public Vehicle vehicleOwnerHistory(List<VehicleOwnershipActivity> vehicleOwnerHistory) {
        this.vehicleOwnerHistory = vehicleOwnerHistory;
        return this;
    }

    public Vehicle addVehicleOwnerHistoryItem(VehicleOwnershipActivity vehicleOwnerHistoryItem) {
        if (this.vehicleOwnerHistory == null) {
            this.vehicleOwnerHistory = new ArrayList<VehicleOwnershipActivity>();
        }
        this.vehicleOwnerHistory.add(vehicleOwnerHistoryItem);
        return this;
    }

    @ApiModelProperty(value="ownership history for the vehicle (Please note that ownership activity is a separately licensed section of the vehicle history responses. Please contact your Red Mountain sales team if you wish to receive ownership activity information)")
    public List<VehicleOwnershipActivity> getVehicleOwnerHistory() {
        return this.vehicleOwnerHistory;
    }

    public void setVehicleOwnerHistory(List<VehicleOwnershipActivity> vehicleOwnerHistory) {
        this.vehicleOwnerHistory = vehicleOwnerHistory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vehicle vehicle = (Vehicle)o;
        return Objects.equals(this.history, vehicle.history) && Objects.equals(this.recalls, vehicle.recalls) && Objects.equals(this.referenceNumber, vehicle.referenceNumber) && Objects.equals(this.scoring, vehicle.scoring) && Objects.equals(this.vehicleInformation, vehicle.vehicleInformation) && Objects.equals(this.vehicleOwnerHistory, vehicle.vehicleOwnerHistory);
    }

    public int hashCode() {
        return Objects.hash(this.history, this.recalls, this.referenceNumber, this.scoring, this.vehicleInformation, this.vehicleOwnerHistory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Vehicle {\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    recalls: ").append(this.toIndentedString(this.recalls)).append("\n");
        sb.append("    referenceNumber: ").append(this.toIndentedString(this.referenceNumber)).append("\n");
        sb.append("    scoring: ").append(this.toIndentedString(this.scoring)).append("\n");
        sb.append("    vehicleInformation: ").append(this.toIndentedString(this.vehicleInformation)).append("\n");
        sb.append("    vehicleOwnerHistory: ").append(this.toIndentedString(this.vehicleOwnerHistory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

