/*
 * AutoCheck Insurance Services API
 * API for methods pertaining to all AutoCheck Insurance services
 *
 * OpenAPI spec version: 2.0.11
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.api;

import com.autocheckinsurance.sdk.ApiCallback;
import com.autocheckinsurance.sdk.ApiClient;
import com.autocheckinsurance.sdk.ApiException;
import com.autocheckinsurance.sdk.ApiResponse;
import com.autocheckinsurance.sdk.Configuration;
import com.autocheckinsurance.sdk.Pair;
import com.autocheckinsurance.sdk.ProgressRequestBody;
import com.autocheckinsurance.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.autocheckinsurance.sdk.model.Empty;

import java.lang.reflect.Type;

public class AutoCheckInsuranceApi {
    private ApiClient apiClient;

    public AutoCheckInsuranceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AutoCheckInsuranceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for brickftp
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (optional)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call brickftpCall(String xApiKey, String xAutotecId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/webhook/brickftp";

        java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
        java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();

        java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
        if (xApiKey != null)
        localVarHeaderParams.put("x-api-key", apiClient.parameterToString(xApiKey));
        if (xAutotecId != null)
        localVarHeaderParams.put("x-autotec-id", apiClient.parameterToString(xAutotecId));

        java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "CustomerAuthorizer" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call brickftpValidateBeforeCall(String xApiKey, String xAutotecId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = brickftpCall(xApiKey, xAutotecId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Webhook for BrickFTP implementations
     * The method used as webhook for BrickFTP implementations
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (optional)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (optional)
     * @return Empty
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Empty brickftp(String xApiKey, String xAutotecId) throws ApiException {
        ApiResponse<Empty> resp = brickftpWithHttpInfo(xApiKey, xAutotecId);
        return resp.getData();
    }

    /**
     * Webhook for BrickFTP implementations
     * The method used as webhook for BrickFTP implementations
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (optional)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (optional)
     * @return ApiResponse&lt;Empty&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Empty> brickftpWithHttpInfo(String xApiKey, String xAutotecId) throws ApiException {
        com.squareup.okhttp.Call call = brickftpValidateBeforeCall(xApiKey, xAutotecId, null, null);
        Type localVarReturnType = new TypeToken<Empty>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Webhook for BrickFTP implementations (asynchronously)
     * The method used as webhook for BrickFTP implementations
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (optional)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call brickftpAsync(String xApiKey, String xAutotecId, final ApiCallback<Empty> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = brickftpValidateBeforeCall(xApiKey, xAutotecId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Empty>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
