/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.AbiExclusions;
import com.autonomousapps.internal.kotlin.AbiDependenciesKt;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.internal.intermediates.consumer.ExplodingAbi;
import com.autonomousapps.tasks.AndroidClassesTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Types;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.gradle.api.Action;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/autonomousapps/tasks/AbiAnalysisTask;", "Lcom/autonomousapps/tasks/AndroidClassesTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "abiDump", "Lorg/gradle/api/file/RegularFileProperty;", "getAbiDump", "()Lorg/gradle/api/file/RegularFileProperty;", "classes", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "exclusions", "Lorg/gradle/api/provider/Property;", "", "getExclusions", "()Lorg/gradle/api/provider/Property;", "output", "getOutput", "action", "", "AbiAnalysisParameters", "AbiAnalysisWorkAction", "dependency-analysis-gradle-plugin"})
public abstract class AbiAnalysisTask
extends AndroidClassesTask {
    @NotNull
    private final WorkerExecutor workerExecutor;

    @Inject
    public AbiAnalysisTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.setGroup("dependency-analysis");
        this.setDescription("Produces a report of the ABI of this project");
    }

    @Classpath
    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getClasses();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getExclusions();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAbiDump();

    @TaskAction
    public final void action() {
        this.workerExecutor.noIsolation().submit(AbiAnalysisWorkAction.class, new Action(this){
            final /* synthetic */ AbiAnalysisTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(AbiAnalysisParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                ConfigurableFileCollection configurableFileCollection = $this$submit.getClassFiles();
                FileTree fileTree = this.this$0.getClasses().getAsFileTree();
                Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"classes.asFileTree");
                configurableFileCollection.setFrom((Iterable)CollectionsKt.filterToClassFiles((FileCollection)fileTree).getFiles());
                Object[] objectArray = new Object[]{this.this$0.androidClassFiles()};
                $this$submit.getClassFiles().from(objectArray);
                $this$submit.getExclusions().set((Provider)this.this$0.getExclusions());
                $this$submit.getOutput().set((Provider)this.this$0.getOutput());
                $this$submit.getAbiDump().set((Provider)this.this$0.getAbiDump());
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisParameters;", "Lorg/gradle/workers/WorkParameters;", "abiDump", "Lorg/gradle/api/file/RegularFileProperty;", "getAbiDump", "()Lorg/gradle/api/file/RegularFileProperty;", "classFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClassFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "exclusions", "Lorg/gradle/api/provider/Property;", "", "getExclusions", "()Lorg/gradle/api/provider/Property;", "output", "getOutput", "dependency-analysis-gradle-plugin"})
    public static interface AbiAnalysisParameters
    extends WorkParameters {
        @NotNull
        public ConfigurableFileCollection getClassFiles();

        @NotNull
        public Property<String> getExclusions();

        @NotNull
        public RegularFileProperty getOutput();

        @NotNull
        public RegularFileProperty getAbiDump();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisParameters;", "()V", "execute", "", "dependency-analysis-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nAbiAnalysisTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiAnalysisTask.kt\ncom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisWorkAction\n+ 2 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n*L\n1#1,84:1\n66#2:85\n40#2,2:86\n33#2,4:88\n149#2,3:92\n49#2,3:95\n33#2,4:98\n152#2,2:102\n*S KotlinDebug\n*F\n+ 1 AbiAnalysisTask.kt\ncom/autonomousapps/tasks/AbiAnalysisTask$AbiAnalysisWorkAction\n*L\n76#1:85\n76#1:86,2\n76#1:88,4\n80#1:92,3\n80#1:95,3\n80#1:98,4\n80#1:102,2\n*E\n"})
    public static abstract class AbiAnalysisWorkAction
    implements WorkAction<AbiAnalysisParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Object object;
            Set classFiles;
            File outputAbiDump;
            File output;
            block9: {
                block8: {
                    output = UtilsKt.getAndDelete(((AbiAnalysisParameters)this.getParameters()).getOutput());
                    outputAbiDump = UtilsKt.getAndDelete(((AbiAnalysisParameters)this.getParameters()).getAbiDump());
                    Set set2 = ((AbiAnalysisParameters)this.getParameters()).getClassFiles().getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"parameters.classFiles.files");
                    classFiles = set2;
                    object = (String)((AbiAnalysisParameters)this.getParameters()).getExclusions().getOrNull();
                    if (object == null) break block8;
                    String $this$fromJson$iv = object;
                    boolean $i$f$fromJson = false;
                    boolean withNulls$iv$iv = false;
                    boolean $i$f$getJsonAdapter = false;
                    JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(AbiExclusions.class);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
                    JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
                    boolean $i$f$withNulls = false;
                    Object object2 = $this$withNulls$iv$iv$iv.fromJson($this$fromJson$iv);
                    Intrinsics.checkNotNull((Object)object2);
                    object = (AbiExclusions)object2;
                    if (object != null) break block9;
                }
                object = AbiExclusions.Companion.getNONE();
            }
            Object exclusions = object;
            Set<ExplodingAbi> explodingAbi = AbiDependenciesKt.computeAbi(classFiles, (AbiExclusions)exclusions, outputAbiDump);
            File $this$bufferWriteJsonSet_u24default$iv = output;
            String indent$iv = "";
            boolean $i$f$bufferWriteJsonSet = false;
            Closeable closeable = (Closeable)JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink$default((File)$this$bufferWriteJsonSet_u24default$iv, (boolean)false, (int)1, null)));
            Throwable throwable = null;
            try {
                JsonWriter writer$iv = (JsonWriter)closeable;
                boolean bl = false;
                boolean withNulls$iv$iv = false;
                boolean $i$f$getJsonSetAdapter = false;
                Type[] typeArray = new Type[]{ExplodingAbi.class};
                ParameterizedType type$iv$iv = Types.newParameterizedType((Type)((Type)((Object)Set.class)), (Type[])typeArray);
                JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter((Type)type$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter<Set<T>>(type)");
                JsonAdapter $this$withNulls$iv$iv$iv = jsonAdapter;
                boolean $i$f$withNulls = false;
                $this$withNulls$iv$iv$iv.indent(indent$iv).toJson(writer$iv, explodingAbi);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

