/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal;

import com.autonomousapps.internal.Access;
import com.autonomousapps.internal.AnnotationAnalyzer;
import com.autonomousapps.internal.AsmKt;
import com.autonomousapps.internal.ClassAnalyzer;
import com.autonomousapps.internal.ClassRef;
import com.autonomousapps.internal.FieldAnalyzer;
import com.autonomousapps.internal.MethodAnalyzer;
import com.autonomousapps.internal.asm.AnnotationVisitor;
import com.autonomousapps.internal.asm.ClassVisitor;
import com.autonomousapps.internal.asm.FieldVisitor;
import com.autonomousapps.internal.asm.MethodVisitor;
import com.autonomousapps.internal.asm.TypePath;
import com.autonomousapps.internal.utils.RegexKt;
import com.autonomousapps.model.internal.intermediates.consumer.MemberAccess;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\"\u001a\u00020#2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0(0'J\u0016\u0010)\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+H\u0002JK\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\b\u00102\u001a\u0004\u0018\u00010\u00072\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u000103H\u0016\u00a2\u0006\u0002\u00104J\u001a\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\u00072\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020#H\u0016J4\u0010;\u001a\u00020<2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\b\u0010=\u001a\u0004\u0018\u00010>H\u0016JA\u0010?\u001a\u00020@2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\u0010\u0010A\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u000103H\u0016\u00a2\u0006\u0002\u0010BJ\u001c\u0010C\u001a\u00020#2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010D\u001a\u0004\u0018\u00010\u0007H\u0016J,\u0010E\u001a\u0002062\u0006\u0010F\u001a\u00020.2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u00107\u001a\u0004\u0018\u00010\u00072\u0006\u00108\u001a\u000209H\u0016R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\f\"\u0004\b!\u0010\u000e\u00a8\u0006I"}, d2={"Lcom/autonomousapps/internal/ClassAnalyzer;", "Lcom/autonomousapps/internal/asm/ClassVisitor;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lorg/gradle/api/logging/Logger;)V", "binaryClasses", "", "", "Ljava/util/SortedSet;", "Lcom/autonomousapps/model/internal/intermediates/consumer/MemberAccess;", "className", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "classes", "", "Lcom/autonomousapps/internal/ClassRef;", "getClasses", "()Ljava/util/Set;", "fieldAnalyzer", "Lcom/autonomousapps/internal/FieldAnalyzer;", "interfaces", "Ljava/util/TreeSet;", "getInterfaces", "()Ljava/util/TreeSet;", "methodAnalyzer", "Lcom/autonomousapps/internal/MethodAnalyzer;", "source", "getSource", "setSource", "superClass", "getSuperClass", "setSuperClass", "addClass", "", "kind", "Lcom/autonomousapps/internal/ClassRef$Kind;", "getBinaryClasses", "", "", "log", "msgProvider", "Lkotlin/Function0;", "visit", "version", "", "access", "name", "signature", "superName", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitAnnotation", "Lcom/autonomousapps/internal/asm/AnnotationVisitor;", "descriptor", "visible", "", "visitEnd", "visitField", "Lcom/autonomousapps/internal/asm/FieldVisitor;", "value", "", "visitMethod", "Lcom/autonomousapps/internal/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lcom/autonomousapps/internal/asm/MethodVisitor;", "visitSource", "debug", "visitTypeAnnotation", "typeRef", "typePath", "Lcom/autonomousapps/internal/asm/TypePath;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nasm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/ClassAnalyzer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,721:1\n18#2:722\n13409#3,2:723\n1863#4,2:725\n1317#5,2:727\n*S KotlinDebug\n*F\n+ 1 asm.kt\ncom/autonomousapps/internal/ClassAnalyzer\n*L\n266#1:722\n269#1:723,2\n285#1:725,2\n301#1:727,2\n*E\n"})
public final class ClassAnalyzer
extends ClassVisitor {
    @NotNull
    private final Logger logger;
    @Nullable
    private String source;
    public String className;
    @Nullable
    private String superClass;
    @NotNull
    private final TreeSet<String> interfaces;
    @NotNull
    private final Set<ClassRef> classes;
    @NotNull
    private final Map<String, SortedSet<MemberAccess>> binaryClasses;
    @NotNull
    private final MethodAnalyzer methodAnalyzer;
    @NotNull
    private final FieldAnalyzer fieldAnalyzer;

    public ClassAnalyzer(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(589824);
        this.logger = logger;
        this.interfaces = SetsKt.sortedSetOf((Object[])new String[0]);
        this.classes = new LinkedHashSet();
        this.binaryClasses = new LinkedHashMap();
        this.methodAnalyzer = new MethodAnalyzer(this.logger, this.classes, this.binaryClasses);
        this.fieldAnalyzer = new FieldAnalyzer(this.logger, this.classes);
    }

    @Nullable
    public final String getSource() {
        return this.source;
    }

    public final void setSource(@Nullable String string) {
        this.source = string;
    }

    @NotNull
    public final String getClassName() {
        String string = this.className;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"className");
        return null;
    }

    public final void setClassName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.className = string;
    }

    @Nullable
    public final String getSuperClass() {
        return this.superClass;
    }

    public final void setSuperClass(@Nullable String string) {
        this.superClass = string;
    }

    @NotNull
    public final TreeSet<String> getInterfaces() {
        return this.interfaces;
    }

    @NotNull
    public final Set<ClassRef> getClasses() {
        return this.classes;
    }

    @NotNull
    public final Map<String, Set<MemberAccess>> getBinaryClasses() {
        return this.binaryClasses;
    }

    private final void addClass(String className, ClassRef.Kind kind) {
        AsmKt.access$addClass(this.classes, className, kind);
    }

    private final void log(Function0<String> msgProvider) {
        if (!AsmKt.access$getLogDebug()) {
            this.logger.quiet((String)msgProvider.invoke());
        }
    }

    public void visitSource(@Nullable String source, @Nullable String debug) {
        this.log((Function0<String>)((Function0)new Function0<String>(source, debug){
            final /* synthetic */ String $source;
            final /* synthetic */ String $debug;
            {
                this.$source = $source;
                this.$debug = $debug;
                super(0);
            }

            public final String invoke() {
                return "- visitSource: source=" + this.$source + " debug=" + this.$debug;
            }
        }));
        this.source = source;
    }

    public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.log((Function0<String>)((Function0)new Function0<String>(access, name, superName){
                final /* synthetic */ int $access;
                final /* synthetic */ String $name;
                final /* synthetic */ String $superName;
                {
                    this.$access = $access;
                    this.$name = $name;
                    this.$superName = $superName;
                    super(0);
                }

                public final String invoke() {
                    return "ClassAnalyzer#visit: " + Access.Companion.fromInt(this.$access) + " " + this.$name + " extends " + this.$superName;
                }
            }));
            this.setClassName(name);
            this.superClass = superName;
            Collection collection = this.interfaces;
            Object[] $this$orEmpty$iv = interfaces;
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                objectArray = new String[]{};
            }
            CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
            this.addClass("L" + superName + ";", ClassRef.Kind.NOT_ANNOTATION);
            if (interfaces == null) break block2;
            String[] $this$forEach$iv = interfaces;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String i2 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                this.addClass("L" + i2 + ";", ClassRef.Kind.NOT_ANNOTATION);
            }
        }
    }

    @NotNull
    public FieldVisitor visitField(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable Object value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.log((Function0<String>)((Function0)new Function0<String>(access, descriptor, name){
                final /* synthetic */ int $access;
                final /* synthetic */ String $descriptor;
                final /* synthetic */ String $name;
                {
                    this.$access = $access;
                    this.$descriptor = $descriptor;
                    this.$name = $name;
                    super(0);
                }

                public final String invoke() {
                    return "ClassAnalyzer#visitField: " + Access.Companion.fromInt(this.$access) + " " + this.$descriptor + " " + this.$name;
                }
            }));
            this.addClass(descriptor, ClassRef.Kind.NOT_ANNOTATION);
            Object object = signature;
            if (object == null || (object = RegexKt.genericTypes((String)object)) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.addClass(it, ClassRef.Kind.NOT_ANNOTATION);
            }
        }
        return this.fieldAnalyzer;
    }

    @NotNull
    public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.log((Function0<String>)((Function0)new Function0<String>(access, name, descriptor){
            final /* synthetic */ int $access;
            final /* synthetic */ String $name;
            final /* synthetic */ String $descriptor;
            {
                this.$access = $access;
                this.$name = $name;
                this.$descriptor = $descriptor;
                super(0);
            }

            public final String invoke() {
                return "ClassAnalyzer#visitMethod: " + Access.Companion.fromInt(this.$access) + " " + this.$name + " " + this.$descriptor;
            }
        }));
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)RegexKt.getMETHOD_DESCRIPTOR_REGEX(), (CharSequence)descriptor, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult result = (MatchResult)element$iv;
            boolean bl = false;
            this.addClass(result.getValue(), ClassRef.Kind.NOT_ANNOTATION);
        }
        return this.methodAnalyzer;
    }

    @NotNull
    public AnnotationVisitor visitAnnotation(@Nullable String descriptor, boolean visible) {
        this.log((Function0<String>)((Function0)new Function0<String>(descriptor, visible){
            final /* synthetic */ String $descriptor;
            final /* synthetic */ boolean $visible;
            {
                this.$descriptor = $descriptor;
                this.$visible = $visible;
                super(0);
            }

            public final String invoke() {
                return "ClassAnalyzer#visitAnnotation: descriptor=" + this.$descriptor + " visible=" + this.$visible;
            }
        }));
        this.addClass(descriptor, ClassRef.Kind.Companion.annotation(visible));
        return new AnnotationAnalyzer(visible, this.logger, this.classes, 0, null, 24, null);
    }

    @NotNull
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String descriptor, boolean visible) {
        this.log((Function0<String>)((Function0)new Function0<String>(typeRef, typePath, descriptor, visible){
            final /* synthetic */ int $typeRef;
            final /* synthetic */ TypePath $typePath;
            final /* synthetic */ String $descriptor;
            final /* synthetic */ boolean $visible;
            {
                this.$typeRef = $typeRef;
                this.$typePath = $typePath;
                this.$descriptor = $descriptor;
                this.$visible = $visible;
                super(0);
            }

            public final String invoke() {
                return "ClassAnalyzer#visitTypeAnnotation: typeRef=" + this.$typeRef + " typePath=" + this.$typePath + " descriptor=" + this.$descriptor + " visible=" + this.$visible;
            }
        }));
        this.addClass(descriptor, ClassRef.Kind.Companion.annotation(visible));
        return new AnnotationAnalyzer(visible, this.logger, this.classes, 0, null, 24, null);
    }

    public void visitEnd() {
        this.log((Function0<String>)((Function0)visitEnd.1.INSTANCE));
    }
}

