/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.exception.BuildHealthException;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/BuildHealthTask;", "Lorg/gradle/api/DefaultTask;", "()V", "consoleReport", "Lorg/gradle/api/file/RegularFileProperty;", "getConsoleReport", "()Lorg/gradle/api/file/RegularFileProperty;", "printBuildHealth", "Lorg/gradle/api/provider/Property;", "", "getPrintBuildHealth", "()Lorg/gradle/api/provider/Property;", "shouldFail", "getShouldFail", "action", "", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nBuildHealthTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildHealthTask.kt\ncom/autonomousapps/tasks/BuildHealthTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public abstract class BuildHealthTask
extends DefaultTask {
    public BuildHealthTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Generates holistic advice for whole project, and can fail the build if desired");
    }

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getShouldFail();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getConsoleReport();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintBuildHealth();

    @TaskAction
    public final void action() {
        StringBuilder stringBuilder;
        File file = ((RegularFile)this.getShouldFail().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"shouldFail.get().asFile");
        boolean shouldFail = Boolean.parseBoolean(FilesKt.readText$default((File)file, null, (int)1, null));
        File file2 = ((RegularFile)this.getConsoleReport().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"consoleReport.get().asFile");
        File consoleReportFile = file2;
        Path consoleReportPath = consoleReportFile.toPath();
        boolean hasAdvice = consoleReportFile.length() > 0L;
        StringBuilder $this$action_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object object = this.getPrintBuildHealth().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"printBuildHealth.get()");
        if (((Boolean)object).booleanValue()) {
            $this$action_u24lambda_u240.append(FilesKt.readText$default((File)consoleReportFile, null, (int)1, null));
        }
        $this$action_u24lambda_u240.append("There were dependency violations. See report at " + consoleReportPath.toUri() + " ");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String output = string;
        if (shouldFail) {
            if (!hasAdvice) {
                boolean bl2 = false;
                String string2 = "Console report should not be blank if buildHealth should fail";
                throw new IllegalStateException(string2.toString());
            }
            throw new BuildHealthException(output);
        }
        if (hasAdvice) {
            this.getLogger().quiet(output);
        }
    }
}

