/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.model.intermediates;

import com.autonomousapps.internal.utils.GradleStringsKt;
import com.autonomousapps.model.AnnotationProcessorCapability;
import com.autonomousapps.model.Capability;
import com.autonomousapps.model.Coordinates;
import com.autonomousapps.model.intermediates.DependencyView;
import com.squareup.moshi.JsonClass;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J-\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/autonomousapps/model/intermediates/AnnotationProcessorDependency;", "Lcom/autonomousapps/model/intermediates/DependencyView;", "processor", "", "supportedAnnotationTypes", "", "artifact", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "(Ljava/lang/String;Ljava/util/Set;Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;)V", "coordinates", "Lcom/autonomousapps/model/Coordinates;", "(Lcom/autonomousapps/model/Coordinates;Ljava/lang/String;Ljava/util/Set;)V", "getCoordinates", "()Lcom/autonomousapps/model/Coordinates;", "getProcessor", "()Ljava/lang/String;", "getSupportedAnnotationTypes", "()Ljava/util/Set;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toCapabilities", "", "Lcom/autonomousapps/model/Capability;", "toString", "dependency-analysis-gradle-plugin"})
public final class AnnotationProcessorDependency
implements DependencyView<AnnotationProcessorDependency> {
    @NotNull
    private final Coordinates coordinates;
    @NotNull
    private final String processor;
    @NotNull
    private final Set<String> supportedAnnotationTypes;

    public AnnotationProcessorDependency(@NotNull Coordinates coordinates, @NotNull String processor, @NotNull Set<String> supportedAnnotationTypes) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter(supportedAnnotationTypes, (String)"supportedAnnotationTypes");
        this.coordinates = coordinates;
        this.processor = processor;
        this.supportedAnnotationTypes = supportedAnnotationTypes;
    }

    @Override
    @NotNull
    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final String getProcessor() {
        return this.processor;
    }

    @NotNull
    public final Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotationTypes;
    }

    public AnnotationProcessorDependency(@NotNull String processor, @NotNull Set<String> supportedAnnotationTypes, @NotNull ResolvedArtifactResult artifact) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter(supportedAnnotationTypes, (String)"supportedAnnotationTypes");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Coordinates coordinates = GradleStringsKt.toCoordinates(artifact);
        this(coordinates, processor, supportedAnnotationTypes);
    }

    @Override
    @NotNull
    public List<Capability> toCapabilities() {
        return CollectionsKt.listOf((Object)new AnnotationProcessorCapability(this.processor, this.supportedAnnotationTypes));
    }

    @NotNull
    public final Coordinates component1() {
        return this.coordinates;
    }

    @NotNull
    public final String component2() {
        return this.processor;
    }

    @NotNull
    public final Set<String> component3() {
        return this.supportedAnnotationTypes;
    }

    @NotNull
    public final AnnotationProcessorDependency copy(@NotNull Coordinates coordinates, @NotNull String processor, @NotNull Set<String> supportedAnnotationTypes) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter(supportedAnnotationTypes, (String)"supportedAnnotationTypes");
        return new AnnotationProcessorDependency(coordinates, processor, supportedAnnotationTypes);
    }

    public static /* synthetic */ AnnotationProcessorDependency copy$default(AnnotationProcessorDependency annotationProcessorDependency, Coordinates coordinates, String string, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            coordinates = annotationProcessorDependency.coordinates;
        }
        if ((n & 2) != 0) {
            string = annotationProcessorDependency.processor;
        }
        if ((n & 4) != 0) {
            set2 = annotationProcessorDependency.supportedAnnotationTypes;
        }
        return annotationProcessorDependency.copy(coordinates, string, set2);
    }

    @NotNull
    public String toString() {
        return "AnnotationProcessorDependency(coordinates=" + this.coordinates + ", processor=" + this.processor + ", supportedAnnotationTypes=" + this.supportedAnnotationTypes + ")";
    }

    public int hashCode() {
        int result = this.coordinates.hashCode();
        result = result * 31 + this.processor.hashCode();
        result = result * 31 + ((Object)this.supportedAnnotationTypes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotationProcessorDependency)) {
            return false;
        }
        AnnotationProcessorDependency annotationProcessorDependency = (AnnotationProcessorDependency)other;
        if (!Intrinsics.areEqual((Object)this.coordinates, (Object)annotationProcessorDependency.coordinates)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.processor, (Object)annotationProcessorDependency.processor)) {
            return false;
        }
        return Intrinsics.areEqual(this.supportedAnnotationTypes, annotationProcessorDependency.supportedAnnotationTypes);
    }
}

