/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps;

import com.autonomousapps.DependencyAnalysisExtensionKt;
import com.autonomousapps.Flags;
import com.autonomousapps.internal.GradleVersions;
import com.autonomousapps.internal.android.AgpVersion;
import com.autonomousapps.subplugin.ProjectPlugin;
import com.autonomousapps.subplugin.RootPlugin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\f\u0010\b\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\t\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\n\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\u000b\u001a\u00020\u0005*\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lcom/autonomousapps/DependencyAnalysisPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "checkGradleVersion", "applyForProject", "applyForRoot", "checkAgpVersion", "checkPluginWasAppliedToRoot", "dependency-analysis-gradle-plugin"})
public final class DependencyAnalysisPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$apply_u24lambda_u240 = project;
        boolean bl = false;
        this.applyForRoot($this$apply_u24lambda_u240);
        this.checkPluginWasAppliedToRoot($this$apply_u24lambda_u240);
        this.applyForProject($this$apply_u24lambda_u240);
    }

    private final void applyForRoot(Project $this$applyForRoot) {
        if (Intrinsics.areEqual((Object)$this$applyForRoot, (Object)$this$applyForRoot.getRootProject())) {
            this.checkGradleVersion();
            this.checkAgpVersion($this$applyForRoot);
            new RootPlugin($this$applyForRoot).apply();
        }
    }

    private final void checkGradleVersion() {
        if (!GradleVersions.INSTANCE.isAtLeastMinimum()) {
            boolean bl = false;
            String string = "Dependency Analysis Gradle Plugin requires Gradle " + GradleVersions.minGradleVersion.getVersion() + " or higher. Was " + GradleVersions.INSTANCE.getCurrent().getVersion() + ".";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void checkAgpVersion(Project $this$checkAgpVersion) {
        AgpVersion agpVersion;
        try {
            agpVersion = AgpVersion.Companion.current();
        }
        catch (Throwable throwable) {
            $this$checkAgpVersion.getLogger().info("AGP not on classpath; assuming non-Android project");
            return;
        }
        AgpVersion current = agpVersion;
        $this$checkAgpVersion.getLogger().debug("AgpVersion = " + current);
        Flags.Compatibility compatibility = Flags.INSTANCE.compatibility$dependency_analysis_gradle_plugin($this$checkAgpVersion);
        if (compatibility != Flags.Compatibility.NONE && !current.isSupported() && Intrinsics.areEqual((Object)$this$checkAgpVersion, (Object)$this$checkAgpVersion.getRootProject())) {
            String message = "The Dependency Analysis plugin is only known to work with versions of AGP between " + AgpVersion.Companion.getAGP_MIN().getVersion() + " and " + AgpVersion.Companion.getAGP_MAX().getVersion() + ". You are using " + current.getVersion() + ". Proceed at your own risk.";
            switch (WhenMappings.$EnumSwitchMapping$0[compatibility.ordinal()]) {
                case 1: {
                    $this$checkAgpVersion.getLogger().debug(message);
                    break;
                }
                case 2: {
                    $this$checkAgpVersion.getLogger().warn(message);
                    break;
                }
                case 3: {
                    $this$checkAgpVersion.getLogger().error(message);
                    break;
                }
                case 4: {
                    throw new IllegalStateException("Not possible".toString());
                }
            }
        }
    }

    private final void checkPluginWasAppliedToRoot(Project $this$checkPluginWasAppliedToRoot) {
        if (DependencyAnalysisExtensionKt.getExtensionOrNull($this$checkPluginWasAppliedToRoot) == null && !Intrinsics.areEqual((Object)$this$checkPluginWasAppliedToRoot.getRootProject().getName(), (Object)"test")) {
            throw new GradleException("You must apply the plugin to the root project. Current project is " + $this$checkPluginWasAppliedToRoot.getPath());
        }
    }

    private final void applyForProject(Project $this$applyForProject) {
        new ProjectPlugin($this$applyForProject).apply();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Flags.Compatibility.values().length];
            try {
                nArray[Flags.Compatibility.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flags.Compatibility.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flags.Compatibility.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Flags.Compatibility.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

