/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.NetworkException;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UrlJwkProvider
implements JwkProvider {
    @VisibleForTesting
    static final String WELL_KNOWN_JWKS_PATH = "/.well-known/jwks.json";
    final URL url;
    final Proxy proxy;
    private final Integer connectTimeout;
    private final Integer readTimeout;
    private final ObjectReader reader;

    public UrlJwkProvider(URL url) {
        this(url, null, null, null);
    }

    public UrlJwkProvider(URL url, Integer connectTimeout, Integer readTimeout, Proxy proxy) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"A non-null url is required");
        Preconditions.checkArgument((connectTimeout == null || connectTimeout >= 0 ? 1 : 0) != 0, (Object)("Invalid connect timeout value '" + connectTimeout + "'. Must be a non-negative integer."));
        Preconditions.checkArgument((readTimeout == null || readTimeout >= 0 ? 1 : 0) != 0, (Object)("Invalid read timeout value '" + readTimeout + "'. Must be a non-negative integer."));
        this.url = url;
        this.proxy = proxy;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.reader = new ObjectMapper().readerFor(Map.class);
    }

    public UrlJwkProvider(URL url, Integer connectTimeout, Integer readTimeout) {
        this(url, connectTimeout, readTimeout, null);
    }

    public UrlJwkProvider(String domain) {
        this(UrlJwkProvider.urlForDomain(domain));
    }

    static URL urlForDomain(String domain) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domain) ? 1 : 0) != 0, (Object)"A domain is required");
        if (!domain.startsWith("http")) {
            domain = "https://" + domain;
        }
        try {
            URI uri = new URI(domain + WELL_KNOWN_JWKS_PATH).normalize();
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid jwks uri", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getJwks() throws SigningKeyNotFoundException {
        try {
            URLConnection c;
            URLConnection uRLConnection = c = this.proxy == null ? this.url.openConnection() : this.url.openConnection(this.proxy);
            if (this.connectTimeout != null) {
                c.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout != null) {
                c.setReadTimeout(this.readTimeout);
            }
            c.setRequestProperty("Accept", "application/json");
            try (InputStream inputStream = c.getInputStream();){
                Map map = (Map)this.reader.readValue(inputStream);
                return map;
            }
        }
        catch (IOException e) {
            throw new NetworkException("Cannot obtain jwks from url " + this.url.toString(), e);
        }
    }

    public List<Jwk> getAll() throws SigningKeyNotFoundException {
        ArrayList jwks = Lists.newArrayList();
        List keys = (List)this.getJwks().get("keys");
        if (keys == null || keys.isEmpty()) {
            throw new SigningKeyNotFoundException("No keys found in " + this.url.toString(), null);
        }
        try {
            for (Map values : keys) {
                jwks.add(Jwk.fromValues(values));
            }
        }
        catch (IllegalArgumentException e) {
            throw new SigningKeyNotFoundException("Failed to parse jwk from json", e);
        }
        return jwks;
    }

    @Override
    public Jwk get(String keyId) throws JwkException {
        List<Jwk> jwks = this.getAll();
        if (keyId == null && jwks.size() == 1) {
            return jwks.get(0);
        }
        if (keyId != null) {
            for (Jwk jwk : jwks) {
                if (!keyId.equals(jwk.getId())) continue;
                return jwk;
            }
        }
        throw new SigningKeyNotFoundException("No key found in " + this.url.toString() + " with kid " + keyId, null);
    }
}

