/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwk;

import com.auth0.jwk.BucketImpl;
import com.auth0.jwk.GuavaCachedJwkProvider;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.RateLimitedJwkProvider;
import com.auth0.jwk.UrlJwkProvider;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class JwkProviderBuilder {
    private final URL url;
    private Proxy proxy;
    private TimeUnit expiresUnit;
    private long expiresIn;
    private long cacheSize;
    private boolean cached;
    private BucketImpl bucket;
    private boolean rateLimited;

    public JwkProviderBuilder(URL url) {
        if (url == null) {
            throw new IllegalStateException("Cannot build provider without url to jwks");
        }
        this.url = url;
        this.cached = true;
        this.expiresIn = 10L;
        this.expiresUnit = TimeUnit.HOURS;
        this.cacheSize = 5L;
        this.rateLimited = true;
        this.bucket = new BucketImpl(10L, 1L, TimeUnit.MINUTES);
    }

    public JwkProviderBuilder(String domain) {
        this(JwkProviderBuilder.buildJwkUrl(domain));
    }

    private static URL buildJwkUrl(String domain) {
        if (domain == null) {
            throw new IllegalStateException("Cannot build provider without domain");
        }
        return UrlJwkProvider.urlForDomain(domain);
    }

    public JwkProviderBuilder cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public JwkProviderBuilder cached(long cacheSize, long expiresIn, TimeUnit unit) {
        this.cached = true;
        this.cacheSize = cacheSize;
        this.expiresIn = expiresIn;
        this.expiresUnit = unit;
        return this;
    }

    public JwkProviderBuilder rateLimited(boolean rateLimited) {
        this.rateLimited = rateLimited;
        return this;
    }

    public JwkProviderBuilder rateLimited(long bucketSize, long refillRate, TimeUnit unit) {
        this.bucket = new BucketImpl(bucketSize, refillRate, unit);
        return this;
    }

    public JwkProviderBuilder proxied(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public JwkProvider build() {
        JwkProvider urlProvider = new UrlJwkProvider(this.url, null, null, this.proxy);
        if (this.rateLimited) {
            urlProvider = new RateLimitedJwkProvider(urlProvider, this.bucket);
        }
        if (this.cached) {
            urlProvider = new GuavaCachedJwkProvider(urlProvider, this.cacheSize, this.expiresIn, this.expiresUnit);
        }
        return urlProvider;
    }
}

