/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.sms.fragment;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import com.auth0.api.AuthenticatedAPIClient;
import com.auth0.api.callback.BaseCallback;
import com.auth0.lock.event.AuthenticationError;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.sms.R;
import com.auth0.lock.sms.event.CountryCodeSelectedEvent;
import com.auth0.lock.sms.event.SelectCountryCodeEvent;
import com.auth0.lock.sms.event.SmsPasscodeSentEvent;
import com.auth0.lock.sms.task.LoadCountriesTask;
import com.auth0.lock.sms.validation.PhoneNumberValidator;
import com.auth0.lock.sms.widget.PhoneField;
import com.auth0.lock.validation.Validator;
import com.squareup.otto.Subscribe;
import java.util.Locale;
import java.util.Map;

public class RequestCodeFragment
extends BaseTitledFragment {
    public static final String REQUEST_CODE_JWT_ARGUMENT = "REQUEST_CODE_JWT_ARGUMENT";
    private static final String TAG = RequestCodeFragment.class.getName();
    private static final String LAST_PHONE_NUMBER_KEY = "LAST_PHONE_NUMBER";
    private static final String LAST_PHONE_DIAL_CODE_KEY = "LAST_PHONE_DIAL_CODE_KEY";
    AsyncTask<String, Void, Map<String, String>> task;
    Validator validator;
    AuthenticatedAPIClient authClient;
    PhoneField phoneField;
    Button sendButton;
    ProgressBar progressBar;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.v((String)TAG, (String)"Loading countries...");
        this.bus.register((Object)this);
        Bundle arguments = this.getArguments();
        if (arguments != null && arguments.containsKey(REQUEST_CODE_JWT_ARGUMENT)) {
            this.authClient = new AuthenticatedAPIClient(this.client.getClientID(), this.client.getBaseURL(), this.client.getConfigurationURL());
            this.authClient.setJWT(arguments.getString(REQUEST_CODE_JWT_ARGUMENT));
        }
        this.checkForAuthClient();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.bus.unregister((Object)this);
    }

    protected int getTitleResource() {
        return R.string.com_auth0_sms_title_send_passcode;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.com_auth0_fragment_request_code, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.validator = new PhoneNumberValidator(R.id.com_auth0_sms_phone_field, R.string.com_auth0_sms_send_code_error_tile, R.string.com_auth0_sms_send_code_no_phone_message);
        this.phoneField = (PhoneField)view.findViewById(R.id.com_auth0_sms_phone_field);
        this.phoneField.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequestCodeFragment.this.bus.post((Object)new SelectCountryCodeEvent());
            }
        });
        SharedPreferences preferences = this.getActivity().getPreferences(0);
        String phoneNumber = preferences.getString(LAST_PHONE_NUMBER_KEY, null);
        final String dialCode = preferences.getString(LAST_PHONE_DIAL_CODE_KEY, null);
        this.phoneField.setPhoneNumber(phoneNumber);
        this.task = new LoadCountriesTask((Context)this.getActivity()){

            protected void onPostExecute(Map<String, String> codes) {
                RequestCodeFragment.this.task = null;
                if (codes != null) {
                    String code;
                    Locale locale = Locale.getDefault();
                    String string2 = code = dialCode != null ? dialCode : codes.get(locale.getCountry());
                    if (code != null) {
                        RequestCodeFragment.this.phoneField.setDialCode(code);
                    }
                }
            }
        };
        this.task.execute((Object[])new String[]{"com_auth0_countries.json"});
        this.sendButton = (Button)view.findViewById(R.id.com_auth0_sms_access_button);
        this.sendButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RequestCodeFragment.this.requestSmsCode();
            }
        });
        this.progressBar = (ProgressBar)view.findViewById(R.id.com_auth0_sms_send_code_progress_indicator);
        Button hasCodeButton = (Button)view.findViewById(R.id.com_auth0_sms_already_has_code_button);
        hasCodeButton.setVisibility(phoneNumber != null && dialCode != null ? 0 : 8);
        hasCodeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SharedPreferences preferences = RequestCodeFragment.this.getActivity().getPreferences(0);
                String phoneNumber = preferences.getString(RequestCodeFragment.LAST_PHONE_NUMBER_KEY, null);
                String dialCode = preferences.getString(RequestCodeFragment.LAST_PHONE_DIAL_CODE_KEY, null);
                if (phoneNumber != null && dialCode != null) {
                    RequestCodeFragment.this.bus.post((Object)new SmsPasscodeSentEvent(dialCode + phoneNumber));
                }
            }
        });
    }

    private void requestSmsCode() {
        boolean valid;
        AuthenticationError error = this.validator.validateFrom((Fragment)this);
        boolean bl = valid = error == null;
        if (valid) {
            boolean hasClient = this.checkForAuthClient();
            if (hasClient) {
                this.sendRequestCode();
            }
        } else {
            this.bus.post((Object)error);
        }
    }

    private void sendRequestCode() {
        this.sendButton.setEnabled(false);
        this.sendButton.setText((CharSequence)"");
        this.progressBar.setVisibility(0);
        final String phoneNumber = this.phoneField.getCompletePhoneNumber();
        this.authClient.requestSmsCode(phoneNumber, (BaseCallback)new BaseCallback<Void>(){

            public void onSuccess(Void payload) {
                Log.d((String)TAG, (String)("SMS code sent to " + phoneNumber));
                SharedPreferences.Editor editor = RequestCodeFragment.this.getActivity().getPreferences(0).edit();
                editor.putString(RequestCodeFragment.LAST_PHONE_NUMBER_KEY, RequestCodeFragment.this.phoneField.getPhoneNumber());
                editor.putString(RequestCodeFragment.LAST_PHONE_DIAL_CODE_KEY, RequestCodeFragment.this.phoneField.getDialCode());
                editor.apply();
                RequestCodeFragment.this.sendButton.setEnabled(true);
                RequestCodeFragment.this.sendButton.setText(R.string.com_auth0_send_passcode_btn_text);
                RequestCodeFragment.this.progressBar.setVisibility(8);
                RequestCodeFragment.this.bus.post((Object)new SmsPasscodeSentEvent(phoneNumber));
            }

            public void onFailure(Throwable error) {
                RequestCodeFragment.this.bus.post((Object)new AuthenticationError(R.string.com_auth0_sms_send_code_error_tile, R.string.com_auth0_sms_send_code_error_message, error));
                RequestCodeFragment.this.sendButton.setEnabled(true);
                RequestCodeFragment.this.sendButton.setText(R.string.com_auth0_send_passcode_btn_text);
                RequestCodeFragment.this.progressBar.setVisibility(8);
            }
        });
    }

    @Subscribe
    public void onCountrySelected(CountryCodeSelectedEvent event) {
        Log.d((String)TAG, (String)("Received selected country " + event.getIsoCode() + " dial code " + event.getDialCode()));
        this.phoneField.setDialCode(event.getDialCode());
    }

    private boolean checkForAuthClient() {
        boolean noJwt;
        boolean bl = noJwt = this.authClient == null;
        if (noJwt) {
            this.bus.post((Object)new AuthenticationError(R.string.com_auth0_sms_no_jwt_found_title, R.string.com_auth0_sms_no_jwt_found_message));
        }
        return !noJwt;
    }
}

