/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.sms;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.auth0.lock.sms.R;
import com.auth0.lock.sms.adapter.Country;
import com.auth0.lock.sms.adapter.CountryAdapter;
import com.auth0.lock.sms.task.LoadCountriesTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class CountryCodeActivity
extends ActionBarActivity {
    public static final String COUNTRY_CODE = "COUNTRY_CODE";
    public static final String COUNTRY_DIAL_CODE = "COUNTRY_DIAL_CODE";
    private static final String TAG = CountryCodeActivity.class.getName();
    AsyncTask<String, Void, Map<String, String>> task;
    ListView listView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_auth0_activity_country_code);
        ActionBar bar = this.getSupportActionBar();
        if (bar != null) {
            bar.setIcon(17170445);
            bar.setDisplayShowTitleEnabled(false);
            bar.setDisplayUseLogoEnabled(false);
            bar.setDisplayHomeAsUpEnabled(false);
            bar.setDisplayShowCustomEnabled(true);
            bar.setCustomView(R.layout.com_auth0_bar_country_search);
            EditText searchText = (EditText)bar.getCustomView().findViewById(R.id.com_auth0_sms_search_country);
            searchText.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    Log.v((String)TAG, (String)("Filtering with string (" + s + ")"));
                    CountryAdapter adapter = (CountryAdapter)CountryCodeActivity.this.listView.getAdapter();
                    adapter.getFilter().filter(s);
                }

                public void afterTextChanged(Editable s) {
                }
            });
        }
        this.task = new LoadCountriesTask((Context)this){

            protected void onPostExecute(Map<String, String> result) {
                CountryCodeActivity.this.task = null;
                if (result != null) {
                    ArrayList<String> names = new ArrayList<String>(result.keySet());
                    Collections.sort(names);
                    ArrayList<Country> countries = new ArrayList<Country>(names.size());
                    for (String name : names) {
                        countries.add(new Country(name, result.get(name)));
                    }
                    CountryCodeActivity.this.listView.setAdapter((ListAdapter)new CountryAdapter(this.getContext(), countries));
                }
            }
        };
        this.task.execute((Object[])new String[]{"com_auth0_countries.json"});
        this.listView = (ListView)this.findViewById(R.id.com_auth0_sms_country_code_list);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Country country = (Country)parent.getItemAtPosition(position);
                Intent data = new Intent();
                data.putExtra(CountryCodeActivity.COUNTRY_CODE, country.getIsoCode());
                data.putExtra(CountryCodeActivity.COUNTRY_DIAL_CODE, country.getDialCode());
                CountryCodeActivity.this.setResult(-1, data);
                CountryCodeActivity.this.finish();
            }
        });
    }

    public void onStop() {
        super.onStop();
        if (this.task != null) {
            this.task.cancel(true);
        }
    }
}

