/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.react;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.auth0.core.Strategies;
import com.auth0.core.Token;
import com.auth0.core.UserProfile;
import com.auth0.identity.IdentityProvider;
import com.auth0.lock.Lock;
import com.auth0.lock.LockActivity;
import com.auth0.lock.LockContext;
import com.auth0.lock.passwordless.LockPasswordlessActivity;
import com.auth0.lock.receiver.AuthenticationReceiver;
import com.auth0.react.bridge.InitOptions;
import com.auth0.react.bridge.ShowOptions;
import com.auth0.react.bridge.TokenBridge;
import com.auth0.react.bridge.UserProfileBridge;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import java.util.HashMap;
import java.util.Map;

public class LockReactModule
extends ReactContextBaseJavaModule {
    private static final String TAG = LockReactModule.class.getName();
    private static final String REACT_MODULE_NAME = "Auth0LockModule";
    public static final String CONNECTION_NATIVE = "default";
    public static final String CONNECTION_EMAIL = "email";
    public static final String CONNECTION_SMS = "sms";
    private static final String NATIVE_KEY = "DEFAULT";
    private static final String EMAIL_KEY = "EMAIL";
    private static final String SMS_KEY = "SMS";
    static final String MESSAGE_USER_SIGNED_UP = "User signed up";
    static final String MESSAGE_USER_CANCELLED = "User cancelled";
    private final LocalBroadcastManager broadcastManager;
    Lock.Builder lockBuilder;
    Map<Strategies, IdentityProvider> providers;
    private Callback authCallback;
    AuthenticationReceiver authenticationReceiver = new AuthenticationReceiver(){

        public void onAuthentication(@NonNull UserProfile profile, @NonNull Token token) {
            Log.d((String)TAG, (String)("User " + profile.getName() + " with token " + token.getIdToken()));
            LockReactModule.this.authCallbackSuccess(profile, token);
        }

        protected void onSignUp() {
            Log.i((String)TAG, (String)LockReactModule.MESSAGE_USER_SIGNED_UP);
            LockReactModule.this.authCallbackError(LockReactModule.MESSAGE_USER_SIGNED_UP);
        }

        protected void onCancel() {
            Log.i((String)TAG, (String)LockReactModule.MESSAGE_USER_CANCELLED);
            LockReactModule.this.authCallbackError(LockReactModule.MESSAGE_USER_CANCELLED);
        }
    };

    public LockReactModule(ReactApplicationContext reactContext, Map<Strategies, IdentityProvider> providers) {
        this(reactContext, LocalBroadcastManager.getInstance((Context)reactContext.getApplicationContext()), providers);
    }

    LockReactModule(ReactApplicationContext reactApplicationContext, LocalBroadcastManager localBroadcastManager) {
        this(reactApplicationContext, localBroadcastManager, null);
    }

    LockReactModule(ReactApplicationContext reactApplicationContext, LocalBroadcastManager localBroadcastManager, Map<Strategies, IdentityProvider> providers) {
        super(reactApplicationContext);
        this.broadcastManager = localBroadcastManager;
        this.providers = providers;
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put(NATIVE_KEY, CONNECTION_NATIVE);
        constants.put(EMAIL_KEY, CONNECTION_EMAIL);
        constants.put(SMS_KEY, CONNECTION_SMS);
        return constants;
    }

    public String getName() {
        return REACT_MODULE_NAME;
    }

    @ReactMethod
    public void init(ReadableMap options) {
        InitOptions initOptions = new InitOptions(options);
        this.lockBuilder = new Lock.Builder().useWebView(true).clientId(initOptions.getClientId()).domainUrl(initOptions.getDomain()).configurationUrl(initOptions.getConfigurationDomain());
        if (this.providers != null) {
            for (Strategies strategy : this.providers.keySet()) {
                this.lockBuilder.withIdentityProvider(strategy, this.providers.get(strategy));
            }
        }
    }

    @ReactMethod
    public void show(@Nullable ReadableMap options, Callback callback) {
        Intent intent;
        ReactApplicationContext context = this.getReactApplicationContext();
        this.authCallback = callback;
        this.authenticationReceiver.registerIn(this.broadcastManager);
        ShowOptions showOptions = new ShowOptions(options);
        this.lockBuilder.closable(showOptions.isClosable()).authenticationParameters(showOptions.getAuthParams());
        if (showOptions.getConnections() != null) {
            this.lockBuilder.useConnections(showOptions.getConnections());
        }
        LockContext.configureLock((Lock.Builder)this.lockBuilder);
        switch (showOptions.getConnectionType()) {
            case "sms": {
                intent = new Intent((Context)context, LockPasswordlessActivity.class);
                intent.putExtra("PASSWORDLESS_TYPE_PARAMETER", showOptions.useMagicLink() ? 16 : 0);
                break;
            }
            case "email": {
                intent = new Intent((Context)context, LockPasswordlessActivity.class);
                intent.putExtra("PASSWORDLESS_TYPE_PARAMETER", showOptions.useMagicLink() ? 17 : 1);
                break;
            }
            default: {
                intent = new Intent((Context)context, LockActivity.class);
            }
        }
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    private boolean invokeAuthCallback(String err, UserProfile profile, Token token) {
        if (this.authCallback == null) {
            Log.e((String)TAG, (String)("Invalid/old callback called! err: " + err + " profile: " + profile + " token: " + token));
            return false;
        }
        this.authenticationReceiver.unregisterFrom(this.broadcastManager);
        UserProfileBridge userProfileBridge = new UserProfileBridge(profile);
        TokenBridge tokenBridge = new TokenBridge(token);
        this.authCallback.invoke(new Object[]{err, userProfileBridge.toMap(), tokenBridge.toMap()});
        this.authCallback = null;
        return true;
    }

    private boolean authCallbackSuccess(UserProfile profile, Token token) {
        return this.invokeAuthCallback(null, profile, token);
    }

    private boolean authCallbackError(String errorMessage) {
        return this.invokeAuthCallback(errorMessage, null, null);
    }
}

