/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.android.jwt;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.auth0.android.jwt.BaseClaim;
import com.auth0.android.jwt.DecodeException;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class ClaimImpl
extends BaseClaim {
    private final JsonElement value;

    ClaimImpl(@NonNull JsonElement value) {
        this.value = value;
    }

    @Override
    @Nullable
    public Boolean asBoolean() {
        if (!this.value.isJsonPrimitive()) {
            return null;
        }
        return this.value.getAsBoolean();
    }

    @Override
    @Nullable
    public Integer asInt() {
        if (!this.value.isJsonPrimitive()) {
            return null;
        }
        return this.value.getAsInt();
    }

    @Override
    @Nullable
    public Double asDouble() {
        if (!this.value.isJsonPrimitive()) {
            return null;
        }
        return this.value.getAsDouble();
    }

    @Override
    @Nullable
    public String asString() {
        if (!this.value.isJsonPrimitive()) {
            return null;
        }
        return this.value.getAsString();
    }

    @Override
    @Nullable
    public Date asDate() {
        if (!this.value.isJsonPrimitive()) {
            return null;
        }
        long ms = Long.parseLong(this.value.getAsString()) * 1000L;
        return new Date(ms);
    }

    @Override
    public <T> T[] asArray(Class<T> tClazz) throws DecodeException {
        try {
            if (!this.value.isJsonArray() || this.value.isJsonNull()) {
                return (Object[])Array.newInstance(tClazz, 0);
            }
            Gson gson = new Gson();
            JsonArray jsonArr = this.value.getAsJsonArray();
            Object[] arr = (Object[])Array.newInstance(tClazz, jsonArr.size());
            for (int i = 0; i < jsonArr.size(); ++i) {
                arr[i] = gson.fromJson(jsonArr.get(i), tClazz);
            }
            return arr;
        }
        catch (JsonSyntaxException e) {
            throw new DecodeException("Failed to decode claim as array", e);
        }
    }

    @Override
    public <T> List<T> asList(Class<T> tClazz) throws DecodeException {
        try {
            if (!this.value.isJsonArray() || this.value.isJsonNull()) {
                return new ArrayList();
            }
            Gson gson = new Gson();
            JsonArray jsonArr = this.value.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < jsonArr.size(); ++i) {
                list.add(gson.fromJson(jsonArr.get(i), tClazz));
            }
            return list;
        }
        catch (JsonSyntaxException e) {
            throw new DecodeException("Failed to decode claim as list", e);
        }
    }
}

