/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.android.jwt;

import com.auth0.android.jwt.Claim;
import com.auth0.android.jwt.DecodeException;
import com.auth0.android.jwt.JWTPayload;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class JWTDeserializer
implements JsonDeserializer<JWTPayload> {
    JWTDeserializer() {
    }

    public JWTPayload deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull() || !json.isJsonObject()) {
            throw new DecodeException("The token's payload had an invalid JSON format.");
        }
        JsonObject object = json.getAsJsonObject();
        String iss = this.removeString(object, "iss");
        String sub = this.removeString(object, "sub");
        Date exp = this.removeDate(object, "exp");
        Date nbf = this.removeDate(object, "nbf");
        Date iat = this.removeDate(object, "iat");
        String jti = this.removeString(object, "jti");
        String[] aud = this.removeStringOrArray(object, "aud");
        HashMap<String, Claim> extra = new HashMap<String, Claim>();
        for (Map.Entry e : object.entrySet()) {
            extra.put((String)e.getKey(), new Claim((JsonElement)e.getValue()));
        }
        return new JWTPayload(iss, sub, exp, nbf, iat, jti, aud, extra);
    }

    private String[] removeStringOrArray(JsonObject obj, String claimName) {
        String[] arr = null;
        if (obj.has(claimName)) {
            JsonElement arrElement = obj.remove(claimName);
            if (arrElement.isJsonArray()) {
                JsonArray jsonArr = arrElement.getAsJsonArray();
                arr = new String[jsonArr.size()];
                for (int i = 0; i < jsonArr.size(); ++i) {
                    arr[i] = jsonArr.get(i).getAsString();
                }
            } else {
                arr = new String[]{arrElement.getAsString()};
            }
        }
        return arr;
    }

    private Date removeDate(JsonObject obj, String claimName) {
        if (!obj.has(claimName)) {
            return null;
        }
        long ms = obj.remove(claimName).getAsLong() * 1000L;
        return new Date(ms);
    }

    private String removeString(JsonObject obj, String claimName) {
        if (!obj.has(claimName)) {
            return null;
        }
        return obj.remove(claimName).getAsString();
    }
}

