/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.aurelhubert.ahbottomnavigation.R;
import com.aurelhubert.ahbottomnavigation.VerticalScrollingBehavior;

public class AHBottomNavigationBehavior<V extends View>
extends VerticalScrollingBehavior<V> {
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private int mTabLayoutId;
    private boolean hidden = false;
    private ViewPropertyAnimatorCompat mTranslationAnimator;
    private TabLayout mTabLayout;
    private View mTabsHolder;

    public AHBottomNavigationBehavior() {
    }

    public AHBottomNavigationBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AHBottomNavigationBehavior_Params);
        this.mTabLayoutId = a.getResourceId(R.styleable.AHBottomNavigationBehavior_Params_tabLayoutId, -1);
        a.recycle();
    }

    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean layoutChild = super.onLayoutChild(parent, child, layoutDirection);
        if (this.mTabLayout == null && this.mTabLayoutId != -1) {
            this.mTabLayout = this.findTabLayout((View)child);
            this.getTabsHolder();
        }
        return layoutChild;
    }

    private TabLayout findTabLayout(View child) {
        if (this.mTabLayoutId == 0) {
            return null;
        }
        return (TabLayout)child.findViewById(this.mTabLayoutId);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
        return super.onDependentViewChanged(parent, child, dependency);
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, V child, View dependency) {
        super.onDependentViewRemoved(parent, child, dependency);
    }

    @Override
    public void onNestedVerticalOverScroll(CoordinatorLayout coordinatorLayout, V child, int direction, int currentOverScroll, int totalOverScroll) {
    }

    @Override
    public void onDirectionNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
    }

    private void handleDirection(V child, int scrollDirection) {
        if (scrollDirection == -1 && this.hidden) {
            this.hidden = false;
            this.animateOffset(child, 0);
        } else if (scrollDirection == 1 && !this.hidden) {
            this.hidden = true;
            this.animateOffset(child, child.getHeight());
        }
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
        return true;
    }

    private void animateOffset(V child, int offset) {
        this.ensureOrCancelAnimator(child);
        this.mTranslationAnimator.translationY((float)offset).start();
        this.animateTabsHolder(offset);
    }

    private void animateTabsHolder(int offset) {
        if (this.mTabsHolder != null) {
            offset = offset > 0 ? 0 : 1;
            ViewCompat.animate((View)this.mTabsHolder).alpha((float)offset).setDuration(300L).start();
        }
    }

    private void ensureOrCancelAnimator(V child) {
        if (this.mTranslationAnimator == null) {
            this.mTranslationAnimator = ViewCompat.animate(child);
            this.mTranslationAnimator.setDuration(300L);
            this.mTranslationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.mTranslationAnimator.cancel();
        }
    }

    private void getTabsHolder() {
        if (this.mTabLayout != null) {
            this.mTabsHolder = this.mTabLayout.getChildAt(0);
        }
    }

    public static <V extends View> AHBottomNavigationBehavior<V> from(V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof AHBottomNavigationBehavior)) {
            throw new IllegalArgumentException("The view is not associated with AHBottomNavigationBehavior");
        }
        return (AHBottomNavigationBehavior)behavior;
    }

    public void setTabLayoutId(int tabId) {
        this.mTabLayoutId = tabId;
    }

    public void resetOffset(V view) {
        Log.d((String)"AHBottomNavigation", (String)"restoreBottomNavigation");
        this.animateOffset(view, 0);
    }
}

