/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.animation.Animator;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationBehavior;
import com.aurelhubert.ahbottomnavigation.AHBottomNavigationItem;
import com.aurelhubert.ahbottomnavigation.AHHelper;
import com.aurelhubert.ahbottomnavigation.R;
import java.util.ArrayList;

public class AHBottomNavigation
extends FrameLayout {
    private static String TAG = "AHBottomNavigation";
    private static final int MIN_ITEMS = 3;
    private static final int MAX_ITEMS = 5;
    private AHBottomNavigationListener listener;
    private OnTabSelectedListener tabSelectedListener;
    private Context context;
    private ArrayList<AHBottomNavigationItem> items = new ArrayList();
    private ArrayList<View> views = new ArrayList();
    private View backgroundColorView;
    private boolean colored = false;
    private int defaultBackgroundColor = -1;
    private int accentColor = -1;
    private int inactiveColor = -1;
    private int currentItem = 0;
    private int currentColor = 0;
    private float selectedItemWidth;
    private float notSelectedItemWidth;
    private boolean behaviorTranslationEnabled = true;

    public AHBottomNavigation(Context context) {
        super(context);
        this.context = context;
        this.initColors();
    }

    public AHBottomNavigation(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initColors();
    }

    public AHBottomNavigation(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initColors();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initViews();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.createItems();
    }

    private void initColors() {
        this.accentColor = ContextCompat.getColor((Context)this.context, (int)R.color.colorAccent);
        this.inactiveColor = ContextCompat.getColor((Context)this.context, (int)R.color.colorInactive);
    }

    private void initViews() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setElevation(this.context.getResources().getDimension(R.dimen.bottom_navigation_elevation));
            this.setClipToPadding(false);
        }
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = -1;
        params.height = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_height);
        if (this.getParent() instanceof CoordinatorLayout && this.behaviorTranslationEnabled) {
            ((CoordinatorLayout.LayoutParams)params).setBehavior(new AHBottomNavigationBehavior());
        }
        this.setLayoutParams(params);
        if (this.items.size() < 3) {
            Log.w((String)TAG, (String)"The items list should have at least 3 items");
        } else if (this.items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
    }

    private void createItems() {
        this.removeAllViews();
        this.views.clear();
        this.backgroundColorView = new View(this.context);
        if (Build.VERSION.SDK_INT >= 21 && this.colored) {
            FrameLayout.LayoutParams backgroundLayoutParams = new FrameLayout.LayoutParams(-1, -1);
            this.addView(this.backgroundColorView, (ViewGroup.LayoutParams)backgroundLayoutParams);
        }
        LinearLayout linearLayout = new LinearLayout(this.context);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(17);
        int layoutHeight = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_height);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, layoutHeight);
        this.addView((View)linearLayout, (ViewGroup.LayoutParams)layoutParams);
        if (this.items.size() == 3) {
            this.createClassicItems(linearLayout);
        } else {
            this.createSmallItems(linearLayout);
        }
    }

    private void createClassicItems(LinearLayout linearLayout) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        float height = this.context.getResources().getDimension(R.dimen.bottom_navigation_height);
        float minWidth = this.context.getResources().getDimension(R.dimen.bottom_navigation_min_width);
        float maxWidth = this.context.getResources().getDimension(R.dimen.bottom_navigation_max_width);
        int layoutWidth = this.getWidth();
        if (layoutWidth == 0 || this.items.size() == 0) {
            return;
        }
        float itemWidth = layoutWidth / this.items.size();
        if (itemWidth < minWidth) {
            itemWidth = minWidth;
        } else if (itemWidth > maxWidth) {
            itemWidth = maxWidth;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            final int itemIndex = i;
            AHBottomNavigationItem item = this.items.get(itemIndex);
            View view = inflater.inflate(R.layout.bottom_navigation_item, (ViewGroup)this, false);
            ImageView icon = (ImageView)view.findViewById(R.id.bottom_navigation_item_icon);
            TextView title = (TextView)view.findViewById(R.id.bottom_navigation_item_title);
            icon.setImageDrawable(item.getDrawable(this.context));
            title.setText((CharSequence)item.getTitle(this.context));
            if (i == this.currentItem) {
                int activePaddingTop = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_padding_top_active);
                view.setPadding(view.getPaddingLeft(), activePaddingTop, view.getPaddingRight(), view.getPaddingBottom());
            }
            if (this.colored) {
                if (i == this.currentItem) {
                    this.setBackgroundColor(item.getColor(this.context));
                    this.currentColor = item.getColor(this.context);
                }
                icon.setImageDrawable(AHHelper.getTintDrawable(this.context, this.items.get(i).getDrawable(this.context), this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall)));
                title.setTextColor(this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall));
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
                icon.setImageDrawable(AHHelper.getTintDrawable(this.context, this.items.get(i).getDrawable(this.context), this.currentItem == i ? this.accentColor : this.inactiveColor));
                title.setTextColor(this.currentItem == i ? this.accentColor : this.inactiveColor);
            }
            title.setTextSize(0, this.currentItem == i ? this.context.getResources().getDimension(R.dimen.bottom_navigation_text_size_active) : this.context.getResources().getDimension(R.dimen.bottom_navigation_text_size_inactive));
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AHBottomNavigation.this.updateItems(itemIndex);
                }
            });
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams((int)itemWidth, (int)height);
            linearLayout.addView(view, (ViewGroup.LayoutParams)params);
            this.views.add(view);
        }
    }

    private void createSmallItems(LinearLayout linearLayout) {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        float height = this.context.getResources().getDimension(R.dimen.bottom_navigation_height);
        float minWidth = this.context.getResources().getDimension(R.dimen.bottom_navigation_small_inactive_min_width);
        float maxWidth = this.context.getResources().getDimension(R.dimen.bottom_navigation_small_inactive_max_width);
        int layoutWidth = this.getWidth();
        if (layoutWidth == 0 || this.items.size() == 0) {
            return;
        }
        float itemWidth = layoutWidth / this.items.size();
        if (itemWidth < minWidth) {
            itemWidth = minWidth;
        } else if (itemWidth > maxWidth) {
            itemWidth = maxWidth;
        }
        float difference = this.context.getResources().getDimension(R.dimen.bottom_navigation_small_selected_width_difference);
        this.selectedItemWidth = itemWidth + (float)this.items.size() * difference;
        this.notSelectedItemWidth = itemWidth -= difference;
        for (int i = 0; i < this.items.size(); ++i) {
            final int itemIndex = i;
            AHBottomNavigationItem item = this.items.get(itemIndex);
            View view = inflater.inflate(R.layout.bottom_navigation_small_item, (ViewGroup)this, false);
            ImageView icon = (ImageView)view.findViewById(R.id.bottom_navigation_small_item_icon);
            TextView title = (TextView)view.findViewById(R.id.bottom_navigation_small_item_title);
            icon.setImageDrawable(item.getDrawable(this.context));
            title.setText((CharSequence)item.getTitle(this.context));
            if (i == this.currentItem) {
                int activePaddingTop = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_small_padding_top_active);
                int activePaddingBottom = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_padding_bottom);
                view.setPadding(view.getPaddingLeft(), activePaddingTop, view.getPaddingRight(), activePaddingBottom);
            }
            if (this.colored) {
                if (i == this.currentItem) {
                    this.setBackgroundColor(item.getColor(this.context));
                    this.currentColor = item.getColor(this.context);
                }
                icon.setImageDrawable(AHHelper.getTintDrawable(this.context, this.items.get(i).getDrawable(this.context), this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall)));
                title.setTextColor(this.currentItem == i ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall));
            } else {
                this.setBackgroundColor(this.defaultBackgroundColor);
                icon.setImageDrawable(AHHelper.getTintDrawable(this.context, this.items.get(i).getDrawable(this.context), this.currentItem == i ? this.accentColor : this.inactiveColor));
                title.setTextColor(this.currentItem == i ? this.accentColor : this.inactiveColor);
            }
            title.setAlpha(this.currentItem == i ? 1.0f : 0.0f);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AHBottomNavigation.this.updateSmallItems(itemIndex);
                }
            });
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(i == this.currentItem ? (int)this.selectedItemWidth : (int)itemWidth, (int)height);
            linearLayout.addView(view, (ViewGroup.LayoutParams)params);
            this.views.add(view);
        }
    }

    private void updateItems(final int itemIndex) {
        if (this.currentItem == itemIndex) {
            if (this.tabSelectedListener != null) {
                this.tabSelectedListener.onTabSelected(itemIndex, true);
            }
            return;
        }
        int activePaddingTop = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_padding_top_active);
        int inactivePaddingTop = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_padding_top_inactive);
        float activeSize = this.context.getResources().getDimension(R.dimen.bottom_navigation_text_size_active);
        float inactiveSize = this.context.getResources().getDimension(R.dimen.bottom_navigation_text_size_inactive);
        int itemActiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : this.accentColor;
        int itemInactiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall) : this.inactiveColor;
        for (int i = 0; i < this.views.size(); ++i) {
            ImageView icon;
            TextView title;
            View container;
            if (i == itemIndex) {
                container = this.views.get(itemIndex).findViewById(R.id.bottom_navigation_container);
                title = (TextView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_item_title);
                icon = (ImageView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_item_icon);
                AHHelper.updateTopPadding(container, inactivePaddingTop, activePaddingTop);
                AHHelper.updateTextColor(title, itemInactiveColor, itemActiveColor);
                AHHelper.updateTextSize(title, inactiveSize, activeSize);
                AHHelper.updateDrawableColor(this.context, this.items.get(itemIndex).getDrawable(this.context), icon, itemInactiveColor, itemActiveColor);
                if (Build.VERSION.SDK_INT >= 21 && this.colored) {
                    this.backgroundColorView.setBackgroundColor(this.items.get(itemIndex).getColor(this.context));
                    int finalRadius = Math.max(this.getWidth(), this.getHeight());
                    int cx = (int)this.views.get(itemIndex).getX() + this.views.get(itemIndex).getWidth() / 2;
                    int cy = this.views.get(itemIndex).getHeight() / 2;
                    Animator anim = ViewAnimationUtils.createCircularReveal((View)this.backgroundColorView, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
                    anim.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            AHBottomNavigation.this.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    anim.start();
                    continue;
                }
                if (this.colored) {
                    AHHelper.updateViewBackgroundColor((View)this, this.currentColor, this.items.get(itemIndex).getColor(this.context));
                    continue;
                }
                this.setBackgroundColor(this.defaultBackgroundColor);
                continue;
            }
            if (i != this.currentItem) continue;
            container = this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_container);
            title = (TextView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_item_title);
            icon = (ImageView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_item_icon);
            AHHelper.updateTopPadding(container, activePaddingTop, inactivePaddingTop);
            AHHelper.updateTextColor(title, itemActiveColor, itemInactiveColor);
            AHHelper.updateTextSize(title, activeSize, inactiveSize);
            AHHelper.updateDrawableColor(this.context, this.items.get(this.currentItem).getDrawable(this.context), icon, itemActiveColor, itemInactiveColor);
        }
        this.currentItem = itemIndex;
        this.currentColor = this.items.get(this.currentItem).getColor(this.context);
        if (this.listener != null) {
            this.listener.onTabSelected(itemIndex);
        }
        if (this.tabSelectedListener != null) {
            this.tabSelectedListener.onTabSelected(itemIndex, false);
        }
    }

    private void updateSmallItems(final int itemIndex) {
        if (this.currentItem == itemIndex) {
            if (this.tabSelectedListener != null) {
                this.tabSelectedListener.onTabSelected(itemIndex, true);
            }
            return;
        }
        int activePaddingTop = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_small_padding_top_active);
        int inactivePadding = (int)this.context.getResources().getDimension(R.dimen.bottom_navigation_small_padding_top);
        int itemActiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorActiveSmall) : this.accentColor;
        int itemInactiveColor = this.colored ? ContextCompat.getColor((Context)this.context, (int)R.color.colorInactiveSmall) : this.inactiveColor;
        for (int i = 0; i < this.views.size(); ++i) {
            ImageView icon;
            TextView title;
            View container;
            if (i == itemIndex) {
                container = this.views.get(itemIndex).findViewById(R.id.bottom_navigation_small_container);
                title = (TextView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_small_item_title);
                icon = (ImageView)this.views.get(itemIndex).findViewById(R.id.bottom_navigation_small_item_icon);
                AHHelper.updateTopPadding(container, inactivePadding, activePaddingTop);
                AHHelper.updateTextColor(title, itemInactiveColor, itemActiveColor);
                AHHelper.updateAlpha((View)title, 0.0f, 1.0f);
                AHHelper.updateWidth(container, this.notSelectedItemWidth, this.selectedItemWidth);
                AHHelper.updateDrawableColor(this.context, this.items.get(itemIndex).getDrawable(this.context), icon, itemInactiveColor, itemActiveColor);
                if (Build.VERSION.SDK_INT >= 21 && this.colored) {
                    this.backgroundColorView.setBackgroundColor(this.items.get(itemIndex).getColor(this.context));
                    int finalRadius = Math.max(this.getWidth(), this.getHeight());
                    int cx = (int)this.views.get(itemIndex).getX() + this.views.get(itemIndex).getWidth() / 2;
                    int cy = this.views.get(itemIndex).getHeight() / 2;
                    Animator anim = ViewAnimationUtils.createCircularReveal((View)this.backgroundColorView, (int)cx, (int)cy, (float)0.0f, (float)finalRadius);
                    anim.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animation) {
                        }

                        public void onAnimationEnd(Animator animation) {
                            AHBottomNavigation.this.setBackgroundColor(((AHBottomNavigationItem)AHBottomNavigation.this.items.get(itemIndex)).getColor(AHBottomNavigation.this.context));
                        }

                        public void onAnimationCancel(Animator animation) {
                        }

                        public void onAnimationRepeat(Animator animation) {
                        }
                    });
                    anim.start();
                    continue;
                }
                if (this.colored) {
                    AHHelper.updateViewBackgroundColor((View)this, this.currentColor, this.items.get(itemIndex).getColor(this.context));
                    continue;
                }
                this.setBackgroundColor(this.defaultBackgroundColor);
                continue;
            }
            if (i != this.currentItem) continue;
            container = this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_small_container);
            title = (TextView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_small_item_title);
            icon = (ImageView)this.views.get(this.currentItem).findViewById(R.id.bottom_navigation_small_item_icon);
            AHHelper.updateTopPadding(container, activePaddingTop, inactivePadding);
            AHHelper.updateTextColor(title, itemActiveColor, itemInactiveColor);
            AHHelper.updateAlpha((View)title, 1.0f, 0.0f);
            AHHelper.updateWidth(container, this.selectedItemWidth, this.notSelectedItemWidth);
            AHHelper.updateDrawableColor(this.context, this.items.get(this.currentItem).getDrawable(this.context), icon, itemActiveColor, itemInactiveColor);
        }
        this.currentItem = itemIndex;
        this.currentColor = this.items.get(this.currentItem).getColor(this.context);
        if (this.listener != null) {
            this.listener.onTabSelected(itemIndex);
        }
        if (this.tabSelectedListener != null) {
            this.tabSelectedListener.onTabSelected(itemIndex, false);
        }
    }

    public void addItem(AHBottomNavigationItem item) {
        if (this.items.size() >= 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        this.items.add(item);
        this.createItems();
    }

    public void addItems(ArrayList<AHBottomNavigationItem> items) {
        if (items.size() >= 5 || this.items.size() + items.size() > 5) {
            Log.w((String)TAG, (String)"The items list should not have more than 5 items");
        }
        this.items.addAll(items);
        this.createItems();
    }

    public void removeItemAtIndex(int index) {
        if (index < this.items.size()) {
            this.items.remove(index);
            this.createItems();
        }
    }

    public void removeAllItems() {
        this.items.clear();
        this.createItems();
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public boolean isColored() {
        return this.colored;
    }

    public void setColored(boolean colored) {
        this.colored = colored;
        this.createItems();
    }

    public int getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(@ColorInt int defaultBackgroundColor) {
        this.defaultBackgroundColor = defaultBackgroundColor;
        this.createItems();
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public void setAccentColor(int accentColor) {
        this.accentColor = accentColor;
        this.createItems();
    }

    public int getInactiveColor() {
        return this.inactiveColor;
    }

    public void setInactiveColor(int inactiveColor) {
        this.inactiveColor = inactiveColor;
        this.createItems();
    }

    public int getCurrentItem() {
        return this.currentItem;
    }

    public void setCurrentItem(int position) {
        if (position >= this.items.size()) {
            Log.w((String)TAG, (String)("The position is out of bounds of the items (" + this.items.size() + " elements)"));
            return;
        }
        if (this.views.size() == 0) {
            this.currentItem = position;
        } else if (this.items.size() == 3) {
            this.updateItems(position);
        } else {
            this.updateSmallItems(position);
        }
    }

    public boolean isBehaviorTranslationEnabled() {
        return this.behaviorTranslationEnabled;
    }

    public void setBehaviorTranslationEnabled(boolean behaviorTranslationEnabled) {
        this.behaviorTranslationEnabled = behaviorTranslationEnabled;
        if (this.getParent() instanceof CoordinatorLayout) {
            ViewGroup.LayoutParams params = this.getLayoutParams();
            ((CoordinatorLayout.LayoutParams)params).setBehavior((CoordinatorLayout.Behavior)(behaviorTranslationEnabled ? new AHBottomNavigationBehavior() : null));
        }
    }

    @Deprecated
    public void setAHBottomNavigationListener(AHBottomNavigationListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void removeAHBottomNavigationListener() {
        this.listener = null;
    }

    public void setOnTabSelectedListener(OnTabSelectedListener tabSelectedListener) {
        this.tabSelectedListener = tabSelectedListener;
    }

    public void removeOnTabSelectedListener() {
        this.tabSelectedListener = null;
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(int var1, boolean var2);
    }

    @Deprecated
    public static interface AHBottomNavigationListener {
        public void onTabSelected(int var1);
    }
}

