/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.ASN1;
import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.KeyKeys;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSAGenParameterSpec;

public class OneKey {
    protected CBORObject keyMap;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private Object UserData;

    public OneKey() {
        this.keyMap = CBORObject.NewMap();
    }

    public OneKey(CBORObject keyData) throws CoseException {
        if (keyData.getType() != CBORType.Map) {
            throw new CoseException("Key data is malformed");
        }
        this.keyMap = keyData;
        this.CheckKeyState();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OneKey(PublicKey pubKey, PrivateKey privKey) throws CoseException {
        byte[] keyData;
        byte[] oid;
        ArrayList<ASN1.TagValue> alg;
        this.keyMap = CBORObject.NewMap();
        if (pubKey != null) {
            ArrayList<ASN1.TagValue> spki = ASN1.DecodeSubjectPublicKeyInfo(pubKey.getEncoded());
            alg = spki.get((int)0).list;
            if (!Arrays.equals(alg.get((int)0).value, ASN1.oid_ecPublicKey)) throw new CoseException("Unsupported Algorithm");
            oid = alg.get((int)1).value;
            if (oid == null) {
                throw new CoseException("Invalid SPKI structure");
            }
            this.keyMap.Add((Object)KeyKeys.KeyType.AsCBOR(), (Object)KeyKeys.KeyType_EC2);
            if (Arrays.equals(oid, ASN1.Oid_secp256r1)) {
                this.keyMap.Add((Object)KeyKeys.EC2_Curve.AsCBOR(), (Object)KeyKeys.EC2_P256);
            } else if (Arrays.equals(oid, ASN1.Oid_secp384r1)) {
                this.keyMap.Add((Object)KeyKeys.EC2_Curve.AsCBOR(), (Object)KeyKeys.EC2_P384);
            } else {
                if (!Arrays.equals(oid, ASN1.Oid_secp521r1)) throw new CoseException("Unsupported curve");
                this.keyMap.Add((Object)KeyKeys.EC2_Curve.AsCBOR(), (Object)KeyKeys.EC2_P521);
            }
            keyData = spki.get((int)1).value;
            if (keyData[1] == 2 || keyData[1] == 3) {
                this.keyMap.Add((Object)KeyKeys.EC2_X.AsCBOR(), (Object)Arrays.copyOfRange(keyData, 2, keyData.length));
                this.keyMap.Add((Object)KeyKeys.EC2_Y.AsCBOR(), (Object)(keyData[1] != 2 ? 1 : 0));
            } else {
                if (keyData[1] != 4) throw new CoseException("Invalid key data");
                int keyLength = (keyData.length - 2) / 2;
                this.keyMap.Add((Object)KeyKeys.EC2_X.AsCBOR(), (Object)Arrays.copyOfRange(keyData, 2, 2 + keyLength));
                this.keyMap.Add((Object)KeyKeys.EC2_Y.AsCBOR(), (Object)Arrays.copyOfRange(keyData, 2 + keyLength, keyData.length));
            }
            this.publicKey = pubKey;
        }
        if (privKey == null) return;
        ArrayList<ASN1.TagValue> pkl = ASN1.DecodePKCS8(privKey.getEncoded());
        if (pkl.get((int)0).tag != 2) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        alg = pkl.get((int)1).list;
        if (!Arrays.equals(alg.get((int)0).value, ASN1.oid_ecPublicKey)) throw new CoseException("Unsupported Algorithm");
        oid = alg.get((int)1).value;
        if (oid == null) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        if (!this.keyMap.ContainsKey(KeyKeys.KeyType.AsCBOR())) {
            this.keyMap.Add((Object)KeyKeys.KeyType.AsCBOR(), (Object)KeyKeys.KeyType_EC2);
            if (Arrays.equals(oid, ASN1.Oid_secp256r1)) {
                this.keyMap.Add((Object)KeyKeys.EC2_Curve.AsCBOR(), (Object)KeyKeys.EC2_P256);
            } else if (Arrays.equals(oid, ASN1.Oid_secp384r1)) {
                this.keyMap.Add((Object)KeyKeys.EC2_Curve.AsCBOR(), (Object)KeyKeys.EC2_P384);
            } else {
                if (!Arrays.equals(oid, ASN1.Oid_secp521r1)) throw new CoseException("Unsupported curve");
                this.keyMap.Add((Object)KeyKeys.EC2_Curve.AsCBOR(), (Object)KeyKeys.EC2_P521);
            }
        } else if (!this.get(KeyKeys.KeyType).equals(KeyKeys.KeyType_EC2)) {
            throw new CoseException("Public/Private key don't match");
        }
        if (pkl.get((int)2).list.get((int)1).tag != 4) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        keyData = pkl.get((int)2).list.get((int)1).value;
        this.keyMap.Add((Object)KeyKeys.EC2_D.AsCBOR(), (Object)keyData);
        this.privateKey = privKey;
    }

    public void add(KeyKeys keyValue, CBORObject value) {
        this.keyMap.Add((Object)keyValue.AsCBOR(), (Object)value);
    }

    public void add(CBORObject keyValue, CBORObject value) {
        this.keyMap.Add((Object)keyValue, (Object)value);
    }

    public CBORObject get(KeyKeys keyValue) {
        return this.keyMap.get(keyValue.AsCBOR());
    }

    public CBORObject get(CBORObject keyValue) throws CoseException {
        if (keyValue.getType() != CBORType.Number && keyValue.getType() != CBORType.TextString) {
            throw new CoseException("keyValue type is incorrect");
        }
        return this.keyMap.get(keyValue);
    }

    public boolean HasAlgorithmID(AlgorithmID algorithmId) {
        CBORObject thatObj;
        CBORObject thisObj = this.get(KeyKeys.Algorithm);
        CBORObject cBORObject = thatObj = algorithmId == null ? null : algorithmId.AsCBOR();
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyID(String id) {
        CBORObject thatObj = id == null ? null : CBORObject.FromObject((String)id);
        CBORObject thisObj = this.get(KeyKeys.KeyId);
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyType(CBORObject keyTypeObj) {
        CBORObject thatObj = keyTypeObj;
        CBORObject thisObj = this.get(KeyKeys.KeyType);
        boolean result = thatObj == null ? thisObj == null : thatObj.equals(thisObj);
        return result;
    }

    public boolean HasKeyOp(Integer that) {
        boolean result;
        block3: {
            CBORObject thisObj;
            block4: {
                block2: {
                    thisObj = this.get(KeyKeys.Key_Ops);
                    if (that != null) break block2;
                    result = thisObj == null;
                    break block3;
                }
                result = false;
                if (thisObj.getType() != CBORType.Number) break block4;
                if (thisObj.AsInt32() != that.intValue()) break block3;
                result = true;
                break block3;
            }
            if (thisObj.getType() == CBORType.Array) {
                for (int i = 0; i < thisObj.size(); ++i) {
                    if (thisObj.get(i).getType() != CBORType.Number || thisObj.get(i).AsInt32() != that.intValue()) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private void CheckKeyState() throws CoseException {
        CBORObject val = this.get(KeyKeys.KeyType);
        if (val == null || val.getType() != CBORType.Number) {
            throw new CoseException("Missing or incorrect key type field");
        }
        if (val.equals(KeyKeys.KeyType_Octet)) {
            val = this.get(KeyKeys.Octet_K);
            if (val == null || val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
        } else if (val.equals(KeyKeys.KeyType_EC2)) {
            this.CheckECKey();
        } else if (val.equals(KeyKeys.KeyType_OKP)) {
            this.CheckOkpKey();
        } else {
            throw new CoseException("Unsupported key type");
        }
    }

    private void CheckECKey() throws CoseException {
        byte[] oid;
        boolean needPublic = false;
        CBORObject cn = this.get(KeyKeys.EC2_Curve);
        if (cn == KeyKeys.EC2_P256) {
            oid = ASN1.Oid_secp256r1;
        } else if (cn == KeyKeys.EC2_P384) {
            oid = ASN1.Oid_secp384r1;
        } else if (cn == KeyKeys.EC2_P521) {
            oid = ASN1.Oid_secp521r1;
        } else {
            throw new CoseException("Key has an unknown curve");
        }
        try {
            CBORObject val = this.get(KeyKeys.EC2_D);
            if (val != null) {
                if (val.getType() != CBORType.ByteString) {
                    throw new CoseException("Malformed key structure");
                }
                try {
                    byte[] privateBytes = ASN1.EncodeEcPrivateKey(oid, val.GetByteString(), null);
                    byte[] pkcs8 = ASN1.EncodePKCS8(ASN1.AlgorithmIdentifier(ASN1.oid_ecPublicKey, oid), privateBytes, null);
                    KeyFactory fact = KeyFactory.getInstance("EC");
                    PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(pkcs8);
                    this.privateKey = fact.generatePrivate(keyspec);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CoseException("Unsupported Algorithm", e);
                }
                catch (InvalidKeySpecException e) {
                    throw new CoseException("Invalid Private Key", e);
                }
            }
            if ((val = this.get(KeyKeys.EC2_X)) == null) {
                if (this.privateKey == null) {
                    throw new CoseException("Malformed key structure");
                }
                needPublic = true;
            } else if (val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
            val = this.get(KeyKeys.EC2_Y);
            if (val == null) {
                if (this.privateKey == null) {
                    throw new CoseException("Malformed key structure");
                }
                needPublic = true;
            } else if (val.getType() != CBORType.ByteString && val.getType() != CBORType.Boolean) {
                throw new CoseException("Malformed key structure");
            }
            if (this.privateKey != null && needPublic) {
                byte[] pkcs8 = this.privateKey.getEncoded();
                return;
            }
            byte[] spki = null;
            if (spki == null) {
                byte[] rgbKey = null;
                byte[] X = this.get(KeyKeys.EC2_X).GetByteString();
                if (this.get(KeyKeys.EC2_Y).getType() == CBORType.Boolean) {
                    rgbKey = new byte[X.length + 1];
                    System.arraycopy(X, 0, rgbKey, 1, X.length);
                    rgbKey[0] = (byte)(2 + (this.get(KeyKeys.EC2_Y).AsBoolean() ? 1 : 0));
                } else {
                    rgbKey = new byte[X.length * 2 + 1];
                    System.arraycopy(X, 0, rgbKey, 1, X.length);
                    byte[] Y = this.get(KeyKeys.EC2_Y).GetByteString();
                    System.arraycopy(Y, 0, rgbKey, 1 + X.length, X.length);
                    rgbKey[0] = 4;
                }
                spki = ASN1.EncodeSubjectPublicKeyInfo(ASN1.AlgorithmIdentifier(ASN1.oid_ecPublicKey, oid), rgbKey);
            }
            KeyFactory fact = KeyFactory.getInstance("EC");
            X509EncodedKeySpec keyspec = new X509EncodedKeySpec(spki);
            this.publicKey = fact.generatePublic(keyspec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("Alorithm unsupported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CoseException("Internal error on SPKI", e);
        }
    }

    public ECGenParameterSpec GetCurve2() throws CoseException {
        if (this.get(KeyKeys.KeyType) != KeyKeys.KeyType_EC2) {
            throw new CoseException("Not an EC2 key");
        }
        CBORObject cnCurve = this.get(KeyKeys.EC2_Curve);
        if (cnCurve == KeyKeys.EC2_P256) {
            return new ECGenParameterSpec("secp256r1");
        }
        if (cnCurve == KeyKeys.EC2_P384) {
            return new ECGenParameterSpec("secp384r1");
        }
        if (cnCurve == KeyKeys.EC2_P521) {
            return new ECGenParameterSpec("secp521r1");
        }
        throw new CoseException("Unsupported curve " + cnCurve);
    }

    public static OneKey generateKey(AlgorithmID algorithm) throws CoseException {
        OneKey returnThis = null;
        switch (algorithm) {
            case ECDSA_256: {
                returnThis = OneKey.generateECDSAKey("P-256", KeyKeys.EC2_P256);
                break;
            }
            case ECDSA_384: {
                returnThis = OneKey.generateECDSAKey("P-384", KeyKeys.EC2_P384);
                break;
            }
            case ECDSA_512: {
                returnThis = OneKey.generateECDSAKey("P-521", KeyKeys.EC2_P521);
                break;
            }
            default: {
                throw new CoseException("Unknown algorithm");
            }
        }
        returnThis.add(KeyKeys.Algorithm, algorithm.AsCBOR());
        return returnThis;
    }

    public static OneKey generateKey(CBORObject curve) throws CoseException {
        String curveName;
        switch (curve.AsInt32()) {
            case 1: {
                curveName = "P-256";
                break;
            }
            case 2: {
                curveName = "P-384";
                break;
            }
            case 3: {
                curveName = "P-521";
                break;
            }
            default: {
                throw new CoseException("Unkonwn curve");
            }
        }
        OneKey returnThis = OneKey.generateECDHKey(curveName, curve);
        return returnThis;
    }

    private static OneKey generateECDHKey(String curveName, CBORObject curve) throws CoseException {
        try {
            int curveSize;
            switch (curveName) {
                case "P-256": {
                    curveName = "secp256r1";
                    curveSize = 256;
                    break;
                }
                case "P-384": {
                    curveName = "secp384r1";
                    curveSize = 384;
                    break;
                }
                case "P-521": {
                    curveName = "secp521r1";
                    curveSize = 521;
                    break;
                }
                default: {
                    throw new CoseException("Internal Error");
                }
            }
            ECGenParameterSpec paramSpec = new ECGenParameterSpec(curveName);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
            gen.initialize(paramSpec);
            KeyPair keyPair = gen.genKeyPair();
            ECPoint pubPoint = ((ECPublicKey)keyPair.getPublic()).getW();
            byte[] rgbX = OneKey.ArrayFromBigNum(pubPoint.getAffineX(), curveSize);
            byte[] rgbY = OneKey.ArrayFromBigNum(pubPoint.getAffineY(), curveSize);
            byte[] rgbD = OneKey.ArrayFromBigNum(((ECPrivateKey)keyPair.getPrivate()).getS(), curveSize);
            OneKey key = new OneKey();
            key.add(KeyKeys.KeyType, KeyKeys.KeyType_EC2);
            key.add(KeyKeys.EC2_Curve, curve);
            key.add(KeyKeys.EC2_X, CBORObject.FromObject((byte[])rgbX));
            key.add(KeyKeys.EC2_Y, CBORObject.FromObject((byte[])rgbY));
            key.add(KeyKeys.EC2_D, CBORObject.FromObject((byte[])rgbD));
            key.publicKey = keyPair.getPublic();
            key.privateKey = keyPair.getPrivate();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("No provider for algorithm", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CoseException("THe curve is not supported", e);
        }
    }

    private static byte[] ArrayFromBigNum(BigInteger n, int curveSize) {
        byte[] rgb = new byte[(curveSize + 7) / 8];
        byte[] rgb2 = n.toByteArray();
        if (rgb.length == rgb2.length) {
            return rgb2;
        }
        if (rgb2.length > rgb.length) {
            System.arraycopy(rgb2, rgb2.length - rgb.length, rgb, 0, rgb.length);
        } else {
            System.arraycopy(rgb2, 0, rgb, rgb.length - rgb2.length, rgb2.length);
        }
        return rgb;
    }

    private static OneKey generateECDSAKey(String curveName, CBORObject curve) throws CoseException {
        try {
            int curveSize;
            switch (curveName) {
                case "P-256": {
                    curveName = "secp256r1";
                    curveSize = 256;
                    break;
                }
                case "P-384": {
                    curveName = "secp384r1";
                    curveSize = 384;
                    break;
                }
                case "P-521": {
                    curveName = "secp521r1";
                    curveSize = 521;
                    break;
                }
                default: {
                    throw new CoseException("Internal Error");
                }
            }
            ECGenParameterSpec paramSpec = new ECGenParameterSpec(curveName);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
            gen.initialize(paramSpec);
            KeyPair keyPair = gen.genKeyPair();
            ECPoint pubPoint = ((ECPublicKey)keyPair.getPublic()).getW();
            byte[] rgbX = OneKey.ArrayFromBigNum(pubPoint.getAffineX(), curveSize);
            byte[] rgbY = OneKey.ArrayFromBigNum(pubPoint.getAffineY(), curveSize);
            byte[] rgbD = OneKey.ArrayFromBigNum(((ECPrivateKey)keyPair.getPrivate()).getS(), curveSize);
            OneKey key = new OneKey();
            key.add(KeyKeys.KeyType, KeyKeys.KeyType_EC2);
            key.add(KeyKeys.EC2_Curve, curve);
            key.add(KeyKeys.EC2_X, CBORObject.FromObject((byte[])rgbX));
            key.add(KeyKeys.EC2_Y, CBORObject.FromObject((byte[])rgbY));
            key.add(KeyKeys.EC2_D, CBORObject.FromObject((byte[])rgbD));
            key.publicKey = keyPair.getPublic();
            key.privateKey = keyPair.getPrivate();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("No provider for algorithm", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CoseException("The curve is not supported", e);
        }
    }

    public OneKey PublicKey() {
        OneKey newKey = new OneKey();
        CBORObject val = this.get(KeyKeys.KeyType);
        if (val.equals(KeyKeys.KeyType_Octet)) {
            return null;
        }
        if (!val.equals(KeyKeys.KeyType_EC2)) {
            return null;
        }
        newKey.add(KeyKeys.EC2_Curve, this.get(KeyKeys.EC2_Curve));
        newKey.add(KeyKeys.EC2_X, this.get(KeyKeys.EC2_X));
        newKey.add(KeyKeys.EC2_Y, this.get(KeyKeys.EC2_Y));
        newKey.publicKey = this.publicKey;
        for (CBORObject obj : this.keyMap.getKeys()) {
            val = this.keyMap.get(obj);
            if (obj.getType() == CBORType.Number) {
                if (obj.AsInt32() <= 0) continue;
                newKey.add(obj, val);
                continue;
            }
            if (obj.getType() != CBORType.TextString) continue;
            newKey.add(obj, val);
        }
        return newKey;
    }

    public byte[] EncodeToBytes() {
        return this.keyMap.EncodeToBytes();
    }

    public CBORObject AsCBOR() {
        return this.keyMap;
    }

    public PublicKey AsPublicKey() throws CoseException {
        return this.publicKey;
    }

    public PrivateKey AsPrivateKey() throws CoseException {
        return this.privateKey;
    }

    public Object getUserData() {
        return this.UserData;
    }

    public void setUserData(Object newData) {
        this.UserData = newData;
    }

    private void CheckOkpKey() throws CoseException {
        String algName;
        byte[] oid;
        boolean needPublic = false;
        CBORObject cn = this.get(KeyKeys.OKP_Curve);
        if (cn == KeyKeys.OKP_Ed25519) {
            oid = ASN1.Oid_Ed25519;
            algName = "EdDSA";
        } else if (cn == KeyKeys.OKP_Ed448) {
            oid = ASN1.Oid_Ed448;
            algName = "EdDSA";
        } else if (cn == KeyKeys.OKP_X25519) {
            oid = ASN1.Oid_X25519;
            algName = "EdDH";
        } else if (cn == KeyKeys.OKP_X448) {
            oid = ASN1.Oid_X448;
            algName = "ECDH";
        } else {
            throw new CoseException("Key has an unknown curve");
        }
        try {
            CBORObject val = this.get(KeyKeys.OKP_D);
            if (val != null) {
                if (val.getType() != CBORType.ByteString) {
                    throw new CoseException("Malformed key structure");
                }
                try {
                    byte[] privateKeyBytes = ASN1.EncodeOctetString(val.GetByteString());
                    byte[] pkcs8 = ASN1.EncodePKCS8(ASN1.AlgorithmIdentifier(oid, null), privateKeyBytes, null);
                    KeyFactory fact = KeyFactory.getInstance(algName);
                    PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(pkcs8);
                    this.privateKey = fact.generatePrivate(keyspec);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CoseException("Unsupported Algorithm", e);
                }
                catch (InvalidKeySpecException e) {
                    throw new CoseException("Invalid Private Key", e);
                }
            }
            if ((val = this.get(KeyKeys.OKP_X)) == null) {
                if (this.privateKey == null) {
                    throw new CoseException("Malformed key structure");
                }
                needPublic = true;
            } else if (val.getType() != CBORType.ByteString) {
                throw new CoseException("Malformed key structure");
            }
            if (this.privateKey != null && needPublic) {
                byte[] pkcs8 = this.privateKey.getEncoded();
                return;
            }
            byte[] spki = null;
            if (spki == null) {
                byte[] rgbKey = this.get(KeyKeys.OKP_X).GetByteString();
                spki = ASN1.EncodeSubjectPublicKeyInfo(ASN1.AlgorithmIdentifier(oid, null), rgbKey);
            }
            KeyFactory fact = KeyFactory.getInstance("EdDSA");
            X509EncodedKeySpec keyspec = new X509EncodedKeySpec(spki);
            this.publicKey = fact.generatePublic(keyspec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("Alorithm unsupported", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CoseException("Internal error on SPKI", e);
        }
    }

    private static OneKey generateOkpKey(String curveName, CBORObject curve) throws CoseException {
        try {
            switch (curveName) {
                case "Ed25519": {
                    break;
                }
                default: {
                    throw new CoseException("Internal Error");
                }
            }
            EdDSAGenParameterSpec paramSpec = new EdDSAGenParameterSpec(curveName);
            KeyPairGenerator gen = KeyPairGenerator.getInstance("EdDSA");
            gen.initialize((AlgorithmParameterSpec)paramSpec);
            KeyPair keyPair = gen.genKeyPair();
            byte[] rgbX = ((EdDSAPublicKey)keyPair.getPublic()).getEncoded();
            byte[] rgbD = ((EdDSAPrivateKey)keyPair.getPrivate()).getEncoded();
            OneKey key = new OneKey();
            key.add(KeyKeys.KeyType, KeyKeys.KeyType_EC2);
            key.add(KeyKeys.OKP_Curve, curve);
            key.add(KeyKeys.OKP_X, CBORObject.FromObject((byte[])rgbX));
            key.add(KeyKeys.OKP_D, CBORObject.FromObject((byte[])rgbD));
            key.publicKey = keyPair.getPublic();
            key.privateKey = keyPair.getPrivate();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CoseException("No provider for algorithm", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CoseException("The curve is not supported", e);
        }
    }
}

